/*
 * Decompiled with CFR 0.152.
 */
package me.bazhenov.groovysh;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;

class TtyFilterOutputStream
extends FilterOutputStream {
    private final AtomicBoolean isChannelAlive;

    TtyFilterOutputStream(OutputStream out, AtomicBoolean isChannelAlive) {
        super(out);
        this.isChannelAlive = isChannelAlive;
    }

    @Override
    public void write(int c) throws IOException {
        if (this.isChannelAlive.get()) {
            if (c == 10) {
                super.write(c);
                c = 13;
            }
            super.write(c);
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.isChannelAlive.get()) {
            super.flush();
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.isChannelAlive.get()) {
            for (int i = off; i < len; ++i) {
                this.write(b[i]);
            }
        }
    }
}

