/*
 * Decompiled with CFR 0.152.
 */
package me.bazhenov.groovysh.spring;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import me.bazhenov.groovysh.GroovyShellService;
import org.apache.sshd.server.auth.password.PasswordAuthenticator;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanIsAbstractException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class GroovyShellServiceBean
implements InitializingBean,
DisposableBean,
ApplicationContextAware {
    private final GroovyShellService service = this.newService();
    private ApplicationContext applicationContext;
    private boolean launchAtStart = true;
    private boolean publishContextBeans = true;

    private GroovyShellService newService() {
        return new GroovyShellService();
    }

    public void setPort(int port) {
        this.service.setPort(port);
    }

    public void setDisableImportCompletions(boolean disableImportCompletions) {
        this.service.setDisableImportCompletions(disableImportCompletions);
    }

    public void setLaunchAtStart(boolean launchAtStart) {
        this.launchAtStart = launchAtStart;
    }

    public void setPublishContextBeans(boolean publishContextBeans) {
        this.publishContextBeans = publishContextBeans;
    }

    public boolean isLaunchAtStart() {
        return this.launchAtStart;
    }

    public void setBindings(Map<String, Object> bindings) {
        this.service.setBindings(bindings);
    }

    protected GroovyShellService getService() {
        return this.service;
    }

    public void setPasswordAuthenticator(PasswordAuthenticator passwordAuthenticator) {
        this.service.setPasswordAuthenticator(passwordAuthenticator);
    }

    public void setDefaultScriptNames(String scriptNames) {
        if (!scriptNames.trim().isEmpty()) {
            this.service.setDefaultScripts(Arrays.asList(scriptNames.split(",")));
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void destroy() throws Exception {
        this.service.destroy();
    }

    public void afterPropertiesSet() throws Exception {
        if (this.launchAtStart) {
            if (this.applicationContext != null) {
                HashMap<String, Object> bindings = new HashMap<String, Object>();
                if (this.publishContextBeans) {
                    GroovyShellServiceBean.publishContextBeans(bindings, this.applicationContext);
                }
                bindings.put("ctx", this.applicationContext);
                if (this.service.getBindings() != null) {
                    bindings.putAll(this.service.getBindings());
                }
                this.service.setBindings(bindings);
            }
            this.service.start();
        }
    }

    private static void publishContextBeans(Map<String, Object> bindings, ApplicationContext ctx) {
        for (String name : ctx.getBeanDefinitionNames()) {
            if (name.contains("#")) continue;
            try {
                bindings.put(name, ctx.getBean(name));
            }
            catch (BeanIsAbstractException beanIsAbstractException) {
                // empty catch block
            }
        }
    }
}

