/*
 * Decompiled with CFR 0.152.
 */
package one.converter;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import one.converter.Arguments;

public class FlameGraph {
    public static final byte FRAME_INTERPRETED = 0;
    public static final byte FRAME_JIT_COMPILED = 1;
    public static final byte FRAME_INLINED = 2;
    public static final byte FRAME_NATIVE = 3;
    public static final byte FRAME_CPP = 4;
    public static final byte FRAME_KERNEL = 5;
    public static final byte FRAME_C1_COMPILED = 6;
    private final Arguments args;
    private final Frame root = new Frame(3);
    private int depth;
    private long mintotal;

    public FlameGraph(Arguments args) {
        this.args = args;
    }

    public FlameGraph(String ... args) {
        this(new Arguments(args));
    }

    public void parse() throws IOException {
        this.parse(new InputStreamReader((InputStream)new FileInputStream(this.args.input), StandardCharsets.UTF_8));
    }

    public void parse(Reader in) throws IOException {
        try (BufferedReader br = new BufferedReader(in);){
            String line;
            while ((line = br.readLine()) != null) {
                int space = line.lastIndexOf(32);
                if (space <= 0) continue;
                String[] trace = line.substring(0, space).split(";");
                long ticks = Long.parseLong(line.substring(space + 1));
                this.addSample(trace, ticks);
            }
        }
    }

    public void addSample(String[] trace, long ticks) {
        if (this.excludeTrace(trace)) {
            return;
        }
        Frame frame = this.root;
        if (this.args.reverse) {
            int i = trace.length;
            while (--i >= this.args.skip) {
                frame = frame.addChild(trace[i], ticks);
            }
        } else {
            for (int i = this.args.skip; i < trace.length; ++i) {
                frame = frame.addChild(trace[i], ticks);
            }
        }
        frame.addLeaf(ticks);
        this.depth = Math.max(this.depth, trace.length);
    }

    public void dump() throws IOException {
        if (this.args.output == null) {
            this.dump(System.out);
        } else {
            try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(this.args.output), 32768);
                 PrintStream out = new PrintStream((OutputStream)bos, false, "UTF-8");){
                this.dump(out);
            }
        }
    }

    public void dump(PrintStream out) {
        this.mintotal = (long)((double)this.root.total * this.args.minwidth / 100.0);
        int depth = this.mintotal > 1L ? this.root.depth(this.mintotal) : this.depth + 1;
        String tail = FlameGraph.getResource("/flame.html");
        tail = this.printTill(out, tail, "/*height:*/300");
        out.print(Math.min(depth * 16, Short.MAX_VALUE));
        tail = this.printTill(out, tail, "/*title:*/");
        out.print(this.args.title);
        tail = this.printTill(out, tail, "/*reverse:*/false");
        out.print(this.args.reverse);
        tail = this.printTill(out, tail, "/*depth:*/0");
        out.print(depth);
        tail = this.printTill(out, tail, "/*frames:*/");
        this.printFrame(out, "all", this.root, 0, 0L);
        tail = this.printTill(out, tail, "/*highlight:*/");
        out.print(this.args.highlight != null ? "'" + FlameGraph.escape(this.args.highlight) + "'" : "");
        out.print(tail);
    }

    private String printTill(PrintStream out, String data, String till) {
        int index = data.indexOf(till);
        out.print(data.substring(0, index));
        return data.substring(index + till.length());
    }

    private void printFrame(PrintStream out, String title, Frame frame, int level, long x) {
        byte type = frame.getType();
        if (type == 5) {
            title = FlameGraph.stripSuffix(title);
        }
        if ((frame.inlined | frame.c1 | frame.interpreted) != 0L && frame.inlined < frame.total && frame.interpreted < frame.total) {
            out.println("f(" + level + "," + x + "," + frame.total + "," + type + ",'" + FlameGraph.escape(title) + "'," + frame.inlined + "," + frame.c1 + "," + frame.interpreted + ")");
        } else {
            out.println("f(" + level + "," + x + "," + frame.total + "," + type + ",'" + FlameGraph.escape(title) + "')");
        }
        x += frame.self;
        for (Map.Entry e : frame.entrySet()) {
            Frame child = (Frame)e.getValue();
            if (child.total >= this.mintotal) {
                this.printFrame(out, (String)e.getKey(), child, level + 1, x);
            }
            x += child.total;
        }
    }

    private boolean excludeTrace(String[] trace) {
        Pattern include = this.args.include;
        Pattern exclude = this.args.exclude;
        if (include == null && exclude == null) {
            return false;
        }
        for (String frame : trace) {
            if (exclude != null && exclude.matcher(frame).matches()) {
                return true;
            }
            if (include == null || !include.matcher(frame).matches()) continue;
            include = null;
            if (exclude == null) break;
        }
        return include != null;
    }

    static String stripSuffix(String title) {
        return title.substring(0, title.length() - 4);
    }

    static String escape(String s) {
        if (s.indexOf(92) >= 0) {
            s = s.replace("\\", "\\\\");
        }
        if (s.indexOf(39) >= 0) {
            s = s.replace("'", "\\'");
        }
        return s;
    }

    private static String getResource(String name) {
        String string;
        block10: {
            InputStream stream = FlameGraph.class.getResourceAsStream(name);
            try {
                int length;
                if (stream == null) {
                    throw new IOException("No resource found");
                }
                ByteArrayOutputStream result = new ByteArrayOutputStream();
                byte[] buffer = new byte[65536];
                while ((length = stream.read(buffer)) != -1) {
                    result.write(buffer, 0, length);
                }
                string = result.toString("UTF-8");
                if (stream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Can't load resource with name " + name);
                }
            }
            stream.close();
        }
        return string;
    }

    public static void main(String[] cmdline) throws IOException {
        Arguments args = new Arguments(cmdline);
        if (args.input == null) {
            System.out.println("Usage: java -cp ap-loader.jar " + FlameGraph.class.getName() + " [options] input.collapsed [output.html]");
            System.out.println();
            System.out.println("Options:");
            System.out.println("  --title TITLE");
            System.out.println("  --reverse");
            System.out.println("  --minwidth PERCENT");
            System.out.println("  --skip FRAMES");
            System.out.println("  --include PATTERN");
            System.out.println("  --exclude PATTERN");
            System.out.println("  --highlight PATTERN");
            System.exit(1);
        }
        FlameGraph fg = new FlameGraph(args);
        fg.parse();
        fg.dump();
    }

    static class Frame
    extends TreeMap<String, Frame> {
        final byte type;
        long total;
        long self;
        long inlined;
        long c1;
        long interpreted;

        Frame(byte type) {
            this.type = type;
        }

        byte getType() {
            if (this.inlined * 3L >= this.total) {
                return 2;
            }
            if (this.c1 * 2L >= this.total) {
                return 6;
            }
            if (this.interpreted * 2L >= this.total) {
                return 0;
            }
            return this.type;
        }

        private Frame getChild(String title, byte type) {
            Frame child = (Frame)super.get(title);
            if (child == null) {
                child = new Frame(type);
                super.put(title, child);
            }
            return child;
        }

        Frame addChild(String title, long ticks) {
            Frame child;
            this.total += ticks;
            if (title.endsWith("_[j]")) {
                child = this.getChild(FlameGraph.stripSuffix(title), (byte)1);
            } else if (title.endsWith("_[i]")) {
                child = this.getChild(FlameGraph.stripSuffix(title), (byte)1);
                child.inlined += ticks;
            } else if (title.endsWith("_[k]")) {
                child = this.getChild(title, (byte)5);
            } else if (title.endsWith("_[1]")) {
                child = this.getChild(FlameGraph.stripSuffix(title), (byte)1);
                child.c1 += ticks;
            } else if (title.endsWith("_[0]")) {
                child = this.getChild(FlameGraph.stripSuffix(title), (byte)1);
                child.interpreted += ticks;
            } else {
                child = title.contains("::") || title.startsWith("-[") || title.startsWith("+[") ? this.getChild(title, (byte)4) : (title.indexOf(47) > 0 && title.charAt(0) != '[' || title.indexOf(46) > 0 && Character.isUpperCase(title.charAt(0)) ? this.getChild(title, (byte)1) : this.getChild(title, (byte)3));
            }
            return child;
        }

        void addLeaf(long ticks) {
            this.total += ticks;
            this.self += ticks;
        }

        int depth(long cutoff) {
            int depth = 0;
            if (this.size() > 0) {
                for (Frame child : this.values()) {
                    if (child.total < cutoff) continue;
                    depth = Math.max(depth, child.depth(cutoff));
                }
            }
            return depth + 1;
        }
    }
}

