/*
 * Decompiled with CFR 0.152.
 */
package one.converter;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import one.jfr.ClassRef;
import one.jfr.JfrReader;
import one.jfr.MethodRef;
import one.jfr.StackTrace;
import one.jfr.event.Event;
import one.jfr.event.EventAggregator;
import one.jfr.event.ExecutionSample;
import one.proto.Proto;

public class jfr2nflx {
    private static final String[] FRAME_TYPE = new String[]{"jit", "jit", "inlined", "user", "user", "kernel", "jit"};
    private static final byte[] NO_STACK = "[no_stack]".getBytes();
    private static final byte[] UNKNOWN = "[unknown]".getBytes();
    private final JfrReader jfr;
    private final List<ExecutionSample> samples;

    public jfr2nflx(JfrReader jfr) throws IOException {
        this.jfr = jfr;
        this.samples = jfr.readAllEvents(ExecutionSample.class);
    }

    public void dump(OutputStream out) throws IOException {
        long startTime = System.nanoTime();
        int size = this.samples.size();
        long durationTicks = size == 0 ? 0L : this.samples.get((int)(size - 1)).time - this.jfr.startTicks + 1L;
        final Proto profile = new Proto(200000).field(1, 0.0).field(2, Math.max((double)this.jfr.durationNanos() / 1.0E9, (double)durationTicks / (double)this.jfr.ticksPerSec)).field(3, this.packSamples()).field(4, this.packDeltas()).field(6, "async-profiler").field(8, new Proto(32).field(1, "has_node_stack").field(2, "true")).field(8, new Proto(32).field(1, "has_samples_tid").field(2, "true")).field(11, this.packTids());
        final Proto nodes = new Proto(10000);
        final Proto node = new Proto(10000);
        EventAggregator agg = new EventAggregator(false, false);
        for (ExecutionSample sample : this.samples) {
            agg.collect(sample);
        }
        agg.forEach(new EventAggregator.Visitor(){

            @Override
            public void visit(Event event, long value) {
                StackTrace stackTrace = ((jfr2nflx)jfr2nflx.this).jfr.stackTraces.get(event.stackTraceId);
                if (stackTrace != null) {
                    profile.field(5, nodes.field(1, event.stackTraceId).field(2, jfr2nflx.this.packNode(node, stackTrace)));
                    nodes.reset();
                    node.reset();
                }
            }
        });
        out.write(profile.buffer(), 0, profile.size());
        long endTime = System.nanoTime();
        System.out.println("Wrote " + profile.size() + " bytes in " + (double)(endTime - startTime) / 1.0E9 + " s");
    }

    private Proto packNode(Proto node, StackTrace stackTrace) {
        long[] methods = stackTrace.methods;
        byte[] types = stackTrace.types;
        int top = methods.length - 1;
        node.field(1, top >= 0 ? this.getMethodName(methods[top], types[top]) : NO_STACK);
        node.field(2, 1);
        node.field(4, top >= 0 ? FRAME_TYPE[types[top]] : "user");
        Proto frame = new Proto(100);
        while (--top >= 0) {
            node.field(10, frame.field(1, this.getMethodName(methods[top], types[top])).field(2, FRAME_TYPE[types[top]]));
            frame.reset();
        }
        return node;
    }

    private Proto packSamples() {
        Proto proto = new Proto(10000);
        for (ExecutionSample sample : this.samples) {
            proto.writeInt(sample.stackTraceId);
        }
        return proto;
    }

    private Proto packDeltas() {
        Proto proto = new Proto(10000);
        double ticksPerSec = this.jfr.ticksPerSec;
        long prevTime = this.jfr.startTicks;
        for (ExecutionSample sample : this.samples) {
            proto.writeDouble((double)(sample.time - prevTime) / ticksPerSec);
            prevTime = sample.time;
        }
        return proto;
    }

    private Proto packTids() {
        Proto proto = new Proto(10000);
        for (ExecutionSample sample : this.samples) {
            proto.writeInt(sample.tid);
        }
        return proto;
    }

    private byte[] getMethodName(long methodId, byte methodType) {
        MethodRef method = this.jfr.methods.get(methodId);
        if (method == null) {
            return UNKNOWN;
        }
        ClassRef cls = this.jfr.classes.get(method.cls);
        byte[] className = this.jfr.symbols.get(cls.name);
        byte[] methodName = this.jfr.symbols.get(method.name);
        if (methodType >= 3 && methodType <= 5 || className == null || className.length == 0) {
            return methodName;
        }
        byte[] fullName = Arrays.copyOf(className, className.length + 1 + methodName.length);
        fullName[className.length] = 46;
        System.arraycopy(methodName, 0, fullName, className.length + 1, methodName.length);
        return fullName;
    }

    public static void main(String[] args) throws Exception {
        File dst;
        if (args.length < 2) {
            System.out.println("Usage: java -cp ap-loader.jar " + jfr2nflx.class.getName() + " input.jfr output.nflx");
            System.exit(1);
        }
        if ((dst = new File(args[1])).isDirectory()) {
            dst = new File(dst, new File(args[0]).getName().replace(".jfr", ".nflx"));
        }
        try (JfrReader jfr = new JfrReader(args[0]);
             FileOutputStream out = new FileOutputStream(dst);){
            new jfr2nflx(jfr).dump(out);
        }
    }
}

