/*
 * Decompiled with CFR 0.152.
 */
package one.jfr;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import one.jfr.ClassRef;
import one.jfr.Dictionary;
import one.jfr.Element;
import one.jfr.JfrClass;
import one.jfr.JfrField;
import one.jfr.MethodRef;
import one.jfr.StackTrace;
import one.jfr.event.AllocationSample;
import one.jfr.event.ContendedLock;
import one.jfr.event.Event;
import one.jfr.event.ExecutionSample;
import one.jfr.event.LiveObject;

public class JfrReader
implements Closeable {
    private static final int BUFFER_SIZE = 0x200000;
    private static final int CHUNK_HEADER_SIZE = 68;
    private static final int CHUNK_SIGNATURE = 1179406848;
    private final FileChannel ch;
    private ByteBuffer buf;
    private long filePosition;
    public boolean incomplete;
    public long startNanos = Long.MAX_VALUE;
    public long endNanos = Long.MIN_VALUE;
    public long startTicks = Long.MAX_VALUE;
    public long ticksPerSec;
    public final Dictionary<JfrClass> types = new Dictionary();
    public final Map<String, JfrClass> typesByName = new HashMap<String, JfrClass>();
    public final Dictionary<String> threads = new Dictionary();
    public final Dictionary<ClassRef> classes = new Dictionary();
    public final Dictionary<byte[]> symbols = new Dictionary();
    public final Dictionary<MethodRef> methods = new Dictionary();
    public final Dictionary<StackTrace> stackTraces = new Dictionary();
    public final Map<Integer, String> frameTypes = new HashMap<Integer, String>();
    public final Map<Integer, String> threadStates = new HashMap<Integer, String>();
    public final Map<String, String> settings = new HashMap<String, String>();
    private int executionSample;
    private int nativeMethodSample;
    private int allocationInNewTLAB;
    private int allocationOutsideTLAB;
    private int allocationSample;
    private int liveObject;
    private int monitorEnter;
    private int threadPark;
    private int activeSetting;
    private boolean activeSettingHasStack;

    public JfrReader(String fileName) throws IOException {
        this.ch = FileChannel.open(Paths.get(fileName, new String[0]), StandardOpenOption.READ);
        this.buf = ByteBuffer.allocateDirect(0x200000);
        this.buf.flip();
        this.ensureBytes(68);
        if (!this.readChunk(0)) {
            throw new IOException("Incomplete JFR file");
        }
    }

    @Override
    public void close() throws IOException {
        this.ch.close();
    }

    public long durationNanos() {
        return this.endNanos - this.startNanos;
    }

    public long nanosToTicks(long nanos) {
        return (long)((double)(nanos - this.startNanos) * ((double)this.ticksPerSec / 1.0E9)) + this.startTicks;
    }

    public List<Event> readAllEvents() throws IOException {
        return this.readAllEvents(null);
    }

    public <E extends Event> List<E> readAllEvents(Class<E> cls) throws IOException {
        E event;
        ArrayList<E> events = new ArrayList<E>();
        while ((event = this.readEvent(cls)) != null) {
            events.add(event);
        }
        Collections.sort(events);
        return events;
    }

    public Event readEvent() throws IOException {
        return this.readEvent(null);
    }

    public <E extends Event> E readEvent(Class<E> cls) throws IOException {
        while (this.ensureBytes(68)) {
            int pos = this.buf.position();
            int size = this.getVarint();
            int type = this.getVarint();
            if (type == 76 && this.buf.getInt(pos) == 1179406848) {
                if (!this.readChunk(pos)) break;
                continue;
            }
            if (type == this.executionSample || type == this.nativeMethodSample) {
                if (cls == null || cls == ExecutionSample.class) {
                    return (E)this.readExecutionSample();
                }
            } else if (type == this.allocationInNewTLAB) {
                if (cls == null || cls == AllocationSample.class) {
                    return (E)this.readAllocationSample(true);
                }
            } else if (type == this.allocationOutsideTLAB || type == this.allocationSample) {
                if (cls == null || cls == AllocationSample.class) {
                    return (E)this.readAllocationSample(false);
                }
            } else if (type == this.liveObject) {
                if (cls == null || cls == LiveObject.class) {
                    return (E)this.readLiveObject();
                }
            } else if (type == this.monitorEnter) {
                if (cls == null || cls == ContendedLock.class) {
                    return (E)this.readContendedLock(false);
                }
            } else if (type == this.threadPark) {
                if (cls == null || cls == ContendedLock.class) {
                    return (E)this.readContendedLock(true);
                }
            } else if (type == this.activeSetting) {
                this.readActiveSetting();
            }
            if ((pos += size) <= this.buf.limit()) {
                this.buf.position(pos);
                continue;
            }
            this.seek(this.filePosition + (long)pos);
        }
        return null;
    }

    private ExecutionSample readExecutionSample() {
        long time = this.getVarlong();
        int tid = this.getVarint();
        int stackTraceId = this.getVarint();
        int threadState = this.getVarint();
        return new ExecutionSample(time, tid, stackTraceId, threadState);
    }

    private AllocationSample readAllocationSample(boolean tlab) {
        long time = this.getVarlong();
        int tid = this.getVarint();
        int stackTraceId = this.getVarint();
        int classId = this.getVarint();
        long allocationSize = this.getVarlong();
        long tlabSize = tlab ? this.getVarlong() : 0L;
        return new AllocationSample(time, tid, stackTraceId, classId, allocationSize, tlabSize);
    }

    private LiveObject readLiveObject() {
        long time = this.getVarlong();
        int tid = this.getVarint();
        int stackTraceId = this.getVarint();
        int classId = this.getVarint();
        long allocationSize = this.getVarlong();
        long allocatimeTime = this.getVarlong();
        return new LiveObject(time, tid, stackTraceId, classId, allocationSize, allocatimeTime);
    }

    private ContendedLock readContendedLock(boolean hasTimeout) {
        long time = this.getVarlong();
        long duration = this.getVarlong();
        int tid = this.getVarint();
        int stackTraceId = this.getVarint();
        int classId = this.getVarint();
        if (hasTimeout) {
            this.getVarlong();
        }
        long until = this.getVarlong();
        long address = this.getVarlong();
        return new ContendedLock(time, tid, stackTraceId, duration, classId);
    }

    private void readActiveSetting() {
        long time = this.getVarlong();
        long duration = this.getVarlong();
        int tid = this.getVarint();
        if (this.activeSettingHasStack) {
            this.getVarint();
        }
        long id = this.getVarlong();
        String name = this.getString();
        String value = this.getString();
        this.settings.put(name, value);
    }

    private boolean readChunk(int pos) throws IOException {
        if (pos + 68 > this.buf.limit() || this.buf.getInt(pos) != 1179406848) {
            throw new IOException("Not a valid JFR file");
        }
        int version = this.buf.getInt(pos + 4);
        if (version < 131072 || version > 196607) {
            throw new IOException("Unsupported JFR version: " + (version >>> 16) + "." + (version & 0xFFFF));
        }
        long cpOffset = this.buf.getLong(pos + 16);
        long metaOffset = this.buf.getLong(pos + 24);
        if (cpOffset == 0L || metaOffset == 0L) {
            this.incomplete = true;
            return false;
        }
        this.startNanos = Math.min(this.startNanos, this.buf.getLong(pos + 32));
        this.endNanos = Math.max(this.endNanos, this.buf.getLong(pos + 32) + this.buf.getLong(pos + 40));
        this.startTicks = Math.min(this.startTicks, this.buf.getLong(pos + 48));
        this.ticksPerSec = this.buf.getLong(pos + 56);
        this.types.clear();
        this.typesByName.clear();
        long chunkStart = this.filePosition + (long)pos;
        this.readMeta(chunkStart + metaOffset);
        this.readConstantPool(chunkStart + cpOffset);
        this.cacheEventTypes();
        this.seek(chunkStart + 68L);
        return true;
    }

    private void readMeta(long metaOffset) throws IOException {
        this.seek(metaOffset);
        this.ensureBytes(5);
        this.ensureBytes(this.getVarint() - this.buf.position());
        this.getVarint();
        this.getVarlong();
        this.getVarlong();
        this.getVarlong();
        String[] strings = new String[this.getVarint()];
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = this.getString();
        }
        this.readElement(strings);
    }

    private Element readElement(String[] strings) {
        String name = strings[this.getVarint()];
        int attributeCount = this.getVarint();
        HashMap<String, String> attributes = new HashMap<String, String>(attributeCount);
        for (int i = 0; i < attributeCount; ++i) {
            attributes.put(strings[this.getVarint()], strings[this.getVarint()]);
        }
        Element e = this.createElement(name, attributes);
        int childCount = this.getVarint();
        for (int i = 0; i < childCount; ++i) {
            e.addChild(this.readElement(strings));
        }
        return e;
    }

    private Element createElement(String name, Map<String, String> attributes) {
        switch (name) {
            case "class": {
                JfrClass type = new JfrClass(attributes);
                if (!attributes.containsKey("superType")) {
                    this.types.put(type.id, type);
                }
                this.typesByName.put(type.name, type);
                return type;
            }
            case "field": {
                return new JfrField(attributes);
            }
        }
        return new Element();
    }

    private void readConstantPool(long cpOffset) throws IOException {
        long delta;
        do {
            this.seek(cpOffset);
            this.ensureBytes(5);
            this.ensureBytes(this.getVarint() - this.buf.position());
            this.getVarint();
            this.getVarlong();
            this.getVarlong();
            delta = this.getVarlong();
            this.getVarint();
            int poolCount = this.getVarint();
            for (int i = 0; i < poolCount; ++i) {
                int type = this.getVarint();
                this.readConstants(this.types.get(type));
            }
        } while (delta != 0L && (cpOffset += delta) > 0L);
    }

    private void readConstants(JfrClass type) {
        switch (type.name) {
            case "jdk.types.ChunkHeader": {
                this.buf.position(this.buf.position() + 71);
                break;
            }
            case "java.lang.Thread": {
                this.readThreads(type.fields.size());
                break;
            }
            case "java.lang.Class": {
                this.readClasses(type.fields.size());
                break;
            }
            case "jdk.types.Symbol": {
                this.readSymbols();
                break;
            }
            case "jdk.types.Method": {
                this.readMethods();
                break;
            }
            case "jdk.types.StackTrace": {
                this.readStackTraces();
                break;
            }
            case "jdk.types.FrameType": {
                this.readMap(this.frameTypes);
                break;
            }
            case "jdk.types.ThreadState": {
                this.readMap(this.threadStates);
                break;
            }
            default: {
                this.readOtherConstants(type.fields);
            }
        }
    }

    private void readThreads(int fieldCount) {
        int count = this.threads.preallocate(this.getVarint());
        for (int i = 0; i < count; ++i) {
            long id = this.getVarlong();
            String osName = this.getString();
            int osThreadId = this.getVarint();
            String javaName = this.getString();
            long javaThreadId = this.getVarlong();
            this.readFields(fieldCount - 4);
            this.threads.put(id, javaName != null ? javaName : osName);
        }
    }

    private void readClasses(int fieldCount) {
        int count = this.classes.preallocate(this.getVarint());
        for (int i = 0; i < count; ++i) {
            long id = this.getVarlong();
            long loader = this.getVarlong();
            long name = this.getVarlong();
            long pkg = this.getVarlong();
            int modifiers = this.getVarint();
            this.readFields(fieldCount - 4);
            this.classes.put(id, new ClassRef(name));
        }
    }

    private void readMethods() {
        int count = this.methods.preallocate(this.getVarint());
        for (int i = 0; i < count; ++i) {
            long id = this.getVarlong();
            long cls = this.getVarlong();
            long name = this.getVarlong();
            long sig = this.getVarlong();
            int modifiers = this.getVarint();
            int hidden = this.getVarint();
            this.methods.put(id, new MethodRef(cls, name, sig));
        }
    }

    private void readStackTraces() {
        int count = this.stackTraces.preallocate(this.getVarint());
        for (int i = 0; i < count; ++i) {
            long id = this.getVarlong();
            int truncated = this.getVarint();
            StackTrace stackTrace = this.readStackTrace();
            this.stackTraces.put(id, stackTrace);
        }
    }

    private StackTrace readStackTrace() {
        int depth = this.getVarint();
        long[] methods = new long[depth];
        byte[] types = new byte[depth];
        int[] locations = new int[depth];
        for (int i = 0; i < depth; ++i) {
            methods[i] = this.getVarlong();
            int line = this.getVarint();
            int bci = this.getVarint();
            locations[i] = line << 16 | bci & 0xFFFF;
            types[i] = this.buf.get();
        }
        return new StackTrace(methods, types, locations);
    }

    private void readSymbols() {
        int count = this.symbols.preallocate(this.getVarint());
        for (int i = 0; i < count; ++i) {
            long id = this.getVarlong();
            if (this.buf.get() != 3) {
                throw new IllegalArgumentException("Invalid symbol encoding");
            }
            this.symbols.put(id, this.getBytes());
        }
    }

    private void readMap(Map<Integer, String> map) {
        int count = this.getVarint();
        for (int i = 0; i < count; ++i) {
            map.put(this.getVarint(), this.getString());
        }
    }

    private void readOtherConstants(List<JfrField> fields) {
        int stringType = this.getTypeId("java.lang.String");
        boolean[] numeric = new boolean[fields.size()];
        for (int i = 0; i < numeric.length; ++i) {
            JfrField f = fields.get(i);
            numeric[i] = f.constantPool || f.type != stringType;
        }
        int count = this.getVarint();
        for (int i = 0; i < count; ++i) {
            this.getVarlong();
            this.readFields(numeric);
        }
    }

    private void readFields(boolean[] numeric) {
        for (boolean n : numeric) {
            if (n) {
                this.getVarlong();
                continue;
            }
            this.getString();
        }
    }

    private void readFields(int count) {
        while (count-- > 0) {
            this.getVarlong();
        }
    }

    private void cacheEventTypes() {
        this.executionSample = this.getTypeId("jdk.ExecutionSample");
        this.nativeMethodSample = this.getTypeId("jdk.NativeMethodSample");
        this.allocationInNewTLAB = this.getTypeId("jdk.ObjectAllocationInNewTLAB");
        this.allocationOutsideTLAB = this.getTypeId("jdk.ObjectAllocationOutsideTLAB");
        this.allocationSample = this.getTypeId("jdk.ObjectAllocationSample");
        this.liveObject = this.getTypeId("profiler.LiveObject");
        this.monitorEnter = this.getTypeId("jdk.JavaMonitorEnter");
        this.threadPark = this.getTypeId("jdk.ThreadPark");
        this.activeSetting = this.getTypeId("jdk.ActiveSetting");
        this.activeSettingHasStack = this.activeSetting >= 0 && this.typesByName.get("jdk.ActiveSetting").field("stackTrace") != null;
    }

    private int getTypeId(String typeName) {
        JfrClass type = this.typesByName.get(typeName);
        return type != null ? type.id : -1;
    }

    private int getVarint() {
        int result = 0;
        int shift = 0;
        while (true) {
            byte b = this.buf.get();
            result |= (b & 0x7F) << shift;
            if (b >= 0) {
                return result;
            }
            shift += 7;
        }
    }

    private long getVarlong() {
        long result = 0L;
        for (int shift = 0; shift < 56; shift += 7) {
            byte b = this.buf.get();
            result |= ((long)b & 0x7FL) << shift;
            if (b < 0) continue;
            return result;
        }
        return result | ((long)this.buf.get() & 0xFFL) << 56;
    }

    private String getString() {
        switch (this.buf.get()) {
            case 0: {
                return null;
            }
            case 1: {
                return "";
            }
            case 3: {
                return new String(this.getBytes(), StandardCharsets.UTF_8);
            }
            case 4: {
                char[] chars = new char[this.getVarint()];
                for (int i = 0; i < chars.length; ++i) {
                    chars[i] = (char)this.getVarint();
                }
                return new String(chars);
            }
            case 5: {
                return new String(this.getBytes(), StandardCharsets.ISO_8859_1);
            }
        }
        throw new IllegalArgumentException("Invalid string encoding");
    }

    private byte[] getBytes() {
        byte[] bytes = new byte[this.getVarint()];
        this.buf.get(bytes);
        return bytes;
    }

    private void seek(long pos) throws IOException {
        this.filePosition = pos;
        this.ch.position(pos);
        this.buf.rewind().flip();
    }

    private boolean ensureBytes(int needed) throws IOException {
        if (this.buf.remaining() >= needed) {
            return true;
        }
        this.filePosition += (long)this.buf.position();
        if (this.buf.capacity() < needed) {
            ByteBuffer newBuf = ByteBuffer.allocateDirect(needed);
            newBuf.put(this.buf);
            this.buf = newBuf;
        } else {
            this.buf.compact();
        }
        while (this.ch.read(this.buf) > 0 && this.buf.position() < needed) {
        }
        this.buf.flip();
        return this.buf.limit() > 0;
    }
}

