/*
 * Decompiled with CFR 0.152.
 */
package one.jfr.event;

import one.jfr.event.Event;

public class AllocationSample
extends Event {
    public final int classId;
    public final long allocationSize;
    public final long tlabSize;

    public AllocationSample(long time, int tid, int stackTraceId, int classId, long allocationSize, long tlabSize) {
        super(time, tid, stackTraceId);
        this.classId = classId;
        this.allocationSize = allocationSize;
        this.tlabSize = tlabSize;
    }

    @Override
    public int hashCode() {
        return this.classId * 127 + this.stackTraceId + (this.tlabSize == 0L ? 17 : 0);
    }

    @Override
    public boolean sameGroup(Event o) {
        if (o instanceof AllocationSample) {
            AllocationSample a = (AllocationSample)o;
            return this.classId == a.classId && this.tlabSize == 0L == (a.tlabSize == 0L);
        }
        return false;
    }

    @Override
    public long value() {
        return this.tlabSize != 0L ? this.tlabSize : this.allocationSize;
    }
}

