/*
 * Decompiled with CFR 0.152.
 */
package one.convert;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class Arguments {
    public String title = "Flame Graph";
    public String highlight;
    public String output;
    public String state;
    public Pattern include;
    public Pattern exclude;
    public double minwidth;
    public double grain;
    public int skip;
    public boolean help;
    public boolean reverse;
    public boolean inverted;
    public boolean cpu;
    public boolean wall;
    public boolean alloc;
    public boolean nativemem;
    public boolean leak;
    public boolean live;
    public boolean lock;
    public boolean threads;
    public boolean classify;
    public boolean total;
    public boolean lines;
    public boolean bci;
    public boolean simple;
    public boolean norm;
    public boolean dot;
    public long from;
    public long to;
    public final List<String> files = new ArrayList<String>();

    public Arguments(String ... args) {
        for (int i = 0; i < args.length; ++i) {
            String fieldName;
            String arg = args[i];
            if (arg.startsWith("--")) {
                fieldName = arg.substring(2);
            } else if (arg.startsWith("-") && arg.length() == 2) {
                fieldName = Arguments.alias(arg.charAt(1));
            } else {
                this.files.add(arg);
                continue;
            }
            try {
                Field f = Arguments.class.getDeclaredField(fieldName);
                if ((f.getModifiers() & 0x1A) != 0) {
                    throw new IllegalArgumentException(arg);
                }
                Class<?> type = f.getType();
                if (type == String.class) {
                    f.set(this, args[++i]);
                    continue;
                }
                if (type == Boolean.TYPE) {
                    f.setBoolean(this, true);
                    continue;
                }
                if (type == Integer.TYPE) {
                    f.setInt(this, Integer.parseInt(args[++i]));
                    continue;
                }
                if (type == Double.TYPE) {
                    f.setDouble(this, Double.parseDouble(args[++i]));
                    continue;
                }
                if (type == Long.TYPE) {
                    f.setLong(this, Arguments.parseTimestamp(args[++i]));
                    continue;
                }
                if (type != Pattern.class) continue;
                f.set(this, Pattern.compile(args[++i]));
                continue;
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new IllegalArgumentException(arg);
            }
        }
    }

    private static String alias(char c) {
        switch (c) {
            case 'h': {
                return "help";
            }
            case 'o': {
                return "output";
            }
            case 'r': {
                return "reverse";
            }
            case 'i': {
                return "inverted";
            }
            case 'I': {
                return "include";
            }
            case 'X': {
                return "exclude";
            }
            case 't': {
                return "threads";
            }
            case 's': {
                return "state";
            }
        }
        return String.valueOf(c);
    }

    private static long parseTimestamp(String time) {
        if (time.indexOf(58) < 0) {
            return Long.parseLong(time);
        }
        GregorianCalendar cal = new GregorianCalendar();
        StringTokenizer st = new StringTokenizer(time, "-:.T");
        if (time.indexOf(84) > 0) {
            cal.set(1, Integer.parseInt(st.nextToken()));
            cal.set(2, Integer.parseInt(st.nextToken()) - 1);
            cal.set(5, Integer.parseInt(st.nextToken()));
        }
        cal.set(11, st.hasMoreTokens() ? Integer.parseInt(st.nextToken()) : 0);
        cal.set(12, st.hasMoreTokens() ? Integer.parseInt(st.nextToken()) : 0);
        cal.set(13, st.hasMoreTokens() ? Integer.parseInt(st.nextToken()) : 0);
        cal.set(14, st.hasMoreTokens() ? Integer.parseInt(st.nextToken()) : 0);
        return cal.getTimeInMillis();
    }
}

