/*
 * Decompiled with CFR 0.152.
 */
package one.convert;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Comparator;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import one.convert.Arguments;
import one.convert.CallStack;
import one.convert.Frame;
import one.convert.Index;
import one.convert.ResourceProcessor;

public class FlameGraph
implements Comparator<Frame> {
    private static final Frame[] EMPTY_FRAME_ARRAY = new Frame[0];
    private static final String[] FRAME_SUFFIX = new String[]{"_[0]", "_[j]", "_[i]", "", "", "_[k]", "_[1]"};
    private static final byte HAS_SUFFIX = -128;
    private static final int FLUSH_THRESHOLD = 15000;
    private static final Pattern TID_FRAME_PATTERN = Pattern.compile("\\[(.* )?tid=\\d+]");
    private final Arguments args;
    private final Index<String> cpool = new Index<String>(String.class, "");
    private final Frame root = new Frame(0, 3);
    private final StringBuilder outbuf = new StringBuilder(16000);
    private int[] order;
    private int depth;
    private int lastLevel;
    private long lastX;
    private long lastTotal;
    private long mintotal;

    public FlameGraph(Arguments args) {
        this.args = args;
    }

    public void parseCollapsed(Reader in) throws IOException {
        CallStack stack = new CallStack();
        try (BufferedReader br = new BufferedReader(in);){
            String line;
            while ((line = br.readLine()) != null) {
                int space = line.lastIndexOf(32);
                if (space <= 0) continue;
                long ticks = Long.parseLong(line.substring(space + 1));
                int from = 0;
                while (from < space) {
                    String name;
                    byte type;
                    int to = line.indexOf(59, from);
                    if (to < 0) {
                        to = space;
                    }
                    if (((type = FlameGraph.detectType(name = line.substring(from, to))) & 0xFFFFFF80) != 0) {
                        name = name.substring(0, name.length() - 4);
                        type = (byte)(type ^ 0xFFFFFF80);
                    }
                    stack.push(name, type);
                    from = to + 1;
                }
                this.addSample(stack, ticks);
                stack.clear();
            }
        }
    }

    public void parseHtml(Reader in) throws IOException {
        Frame[] levels = new Frame[128];
        int level = 0;
        long total = 0L;
        boolean needRebuild = this.args.reverse || this.args.include != null || this.args.exclude != null;
        try (BufferedReader br = new BufferedReader(in);){
            String line;
            while (!br.readLine().startsWith("const cpool")) {
            }
            br.readLine();
            String s = "";
            while ((line = br.readLine()).startsWith("'")) {
                String packed = FlameGraph.unescape(line.substring(1, line.lastIndexOf(39)));
                s = s.substring(0, packed.charAt(0) - 32).concat(packed.substring(1));
                this.cpool.put(s, this.cpool.size());
            }
            while (!br.readLine().isEmpty()) {
            }
            while (!(line = br.readLine()).isEmpty()) {
                StringTokenizer st = new StringTokenizer(line.substring(2, line.length() - 1), ",");
                int nameAndType = Integer.parseInt(st.nextToken());
                char func = line.charAt(0);
                if (func == 'f') {
                    level = Integer.parseInt(st.nextToken());
                    st.nextToken();
                } else if (func == 'u') {
                    ++level;
                } else if (func != 'n') {
                    throw new IllegalStateException("Unexpected line: " + line);
                }
                if (st.hasMoreTokens()) {
                    total = Long.parseLong(st.nextToken());
                }
                int titleIndex = nameAndType >>> 3;
                byte type = (byte)(nameAndType & 7);
                if (st.hasMoreTokens() && (type <= 2 || type >= 6)) {
                    type = 1;
                }
                Frame f = level > 0 || needRebuild ? new Frame(titleIndex, type) : this.root;
                f.self = f.total = total;
                if (st.hasMoreTokens()) {
                    f.inlined = Long.parseLong(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    f.c1 = Long.parseLong(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    f.interpreted = Long.parseLong(st.nextToken());
                }
                if (level > 0) {
                    Frame parent = levels[level - 1];
                    parent.put(f.key, f);
                    parent.self -= total;
                    this.depth = Math.max(this.depth, level);
                }
                if (level >= levels.length) {
                    levels = Arrays.copyOf(levels, level * 2);
                }
                levels[level] = f;
            }
        }
        if (needRebuild) {
            this.rebuild(levels[0], new CallStack(), this.cpool.keys());
        }
    }

    private void rebuild(Frame frame, CallStack stack, String[] strings) {
        if (frame.self > 0L) {
            this.addSample(stack, frame.self);
        }
        if (!frame.isEmpty()) {
            for (Frame child : frame.values()) {
                stack.push(strings[child.getTitleIndex()], child.getType());
                this.rebuild(child, stack, strings);
                stack.pop();
            }
        }
    }

    public void addSample(CallStack stack, long ticks) {
        if (this.excludeStack(stack)) {
            return;
        }
        Frame frame = this.root;
        if (this.args.reverse) {
            int skip = this.args.skip;
            if (skip == 0 && stack.size > 0 && FlameGraph.isThreadFrame(stack.names[0], stack.types[0])) {
                frame = this.addChild(frame, stack.names[0], stack.types[0], ticks);
                skip = 1;
            }
            int i = stack.size;
            while (--i >= skip) {
                frame = this.addChild(frame, stack.names[i], stack.types[i], ticks);
            }
        } else {
            for (int i = this.args.skip; i < stack.size; ++i) {
                frame = this.addChild(frame, stack.names[i], stack.types[i], ticks);
            }
        }
        frame.total += ticks;
        frame.self += ticks;
        this.depth = Math.max(this.depth, stack.size);
    }

    public void dump(PrintStream out) {
        this.mintotal = (long)((double)this.root.total * this.args.minwidth / 100.0);
        if ("collapsed".equals(this.args.output)) {
            this.printFrameCollapsed(out, this.root, this.cpool.keys());
            return;
        }
        String tail = ResourceProcessor.getResource("/flame.html");
        tail = ResourceProcessor.printTill(out, tail, "/*height:*/300");
        int depth = this.mintotal > 1L ? this.root.depth(this.mintotal) : this.depth + 1;
        out.print(Math.min(depth * 16, Short.MAX_VALUE));
        tail = ResourceProcessor.printTill(out, tail, "/*title:*/");
        out.print(this.args.title);
        tail = ResourceProcessor.printTill(out, tail, "/*inverted:*/false");
        out.print(this.args.reverse ^ this.args.inverted);
        tail = ResourceProcessor.printTill(out, tail, "/*depth:*/0");
        out.print(depth);
        tail = ResourceProcessor.printTill(out, tail, "/*cpool:*/");
        this.printCpool(out);
        tail = ResourceProcessor.printTill(out, tail, "/*frames:*/");
        this.printFrame(out, this.root, 0, 0L);
        out.print(this.outbuf);
        tail = ResourceProcessor.printTill(out, tail, "/*highlight:*/");
        out.print(this.args.highlight != null ? "'" + FlameGraph.escape(this.args.highlight) + "'" : "");
        out.print(tail);
    }

    private void printCpool(PrintStream out) {
        Object[] strings = this.cpool.keys();
        Arrays.sort(strings);
        out.print("'all'");
        this.order = new int[strings.length];
        Object s = "";
        int i = 1;
        while (i < strings.length) {
            String string = s;
            s = strings[i];
            int prefixLen = Math.min(FlameGraph.getCommonPrefix(string, (String)s), 95);
            out.print(",\n'" + FlameGraph.escape((char)(prefixLen + 32) + ((String)s).substring(prefixLen)) + "'");
            this.order[((Integer)this.cpool.get((Object)s)).intValue()] = i++;
        }
        this.cpool.clear();
    }

    private void printFrame(PrintStream out, Frame frame, int level, long x) {
        int nameAndType = this.order[frame.getTitleIndex()] << 3 | frame.getType();
        boolean hasExtraTypes = (frame.inlined | frame.c1 | frame.interpreted) != 0L && frame.inlined < frame.total && frame.interpreted < frame.total;
        int func = 102;
        if (level == this.lastLevel + 1 && x == this.lastX) {
            func = 117;
        } else if (level == this.lastLevel && x == this.lastX + this.lastTotal) {
            func = 110;
        }
        StringBuilder sb = this.outbuf.append((char)func).append('(').append(nameAndType);
        if (func == 102) {
            sb.append(',').append(level).append(',').append(x - this.lastX);
        }
        if (frame.total != this.lastTotal || hasExtraTypes) {
            sb.append(',').append(frame.total);
            if (hasExtraTypes) {
                sb.append(',').append(frame.inlined).append(',').append(frame.c1).append(',').append(frame.interpreted);
            }
        }
        sb.append(")\n");
        if (sb.length() > 15000) {
            out.print(sb);
            sb.setLength(0);
        }
        this.lastLevel = level;
        this.lastX = x;
        this.lastTotal = frame.total;
        Frame[] children = frame.values().toArray(EMPTY_FRAME_ARRAY);
        Arrays.sort(children, this);
        x += frame.self;
        for (Frame child : children) {
            if (child.total >= this.mintotal) {
                this.printFrame(out, child, level + 1, x);
            }
            x += child.total;
        }
    }

    private void printFrameCollapsed(PrintStream out, Frame frame, String[] strings) {
        StringBuilder sb = this.outbuf;
        int prevLength = sb.length();
        if (frame != this.root) {
            sb.append(strings[frame.getTitleIndex()]).append(FRAME_SUFFIX[frame.getType()]);
            if (frame.self > 0L) {
                int tmpLength = sb.length();
                out.print(sb.append(' ').append(frame.self).append('\n'));
                sb.setLength(tmpLength);
            }
            sb.append(';');
        }
        if (!frame.isEmpty()) {
            for (Frame child : frame.values()) {
                if (child.total < this.mintotal) continue;
                this.printFrameCollapsed(out, child, strings);
            }
        }
        sb.setLength(prevLength);
    }

    private boolean excludeStack(CallStack stack) {
        Pattern include = this.args.include;
        Pattern exclude = this.args.exclude;
        if (include == null && exclude == null) {
            return false;
        }
        for (int i = 0; i < stack.size; ++i) {
            if (exclude != null && exclude.matcher(stack.names[i]).matches()) {
                return true;
            }
            if (include == null || !include.matcher(stack.names[i]).matches()) continue;
            if (exclude == null) {
                return false;
            }
            include = null;
        }
        return include != null;
    }

    private Frame addChild(Frame frame, String title, byte type, long ticks) {
        Frame child;
        frame.total += ticks;
        int titleIndex = this.cpool.index(title);
        switch (type) {
            case 0: {
                child = frame.getChild(titleIndex, (byte)1);
                child.interpreted += ticks;
                break;
            }
            case 2: {
                child = frame.getChild(titleIndex, (byte)1);
                child.inlined += ticks;
                break;
            }
            case 6: {
                child = frame.getChild(titleIndex, (byte)1);
                child.c1 += ticks;
                break;
            }
            default: {
                child = frame.getChild(titleIndex, type);
            }
        }
        return child;
    }

    private static byte detectType(String title) {
        if (title.endsWith("_[j]")) {
            return -127;
        }
        if (title.endsWith("_[i]")) {
            return -126;
        }
        if (title.endsWith("_[k]")) {
            return -123;
        }
        if (title.endsWith("_[0]")) {
            return -128;
        }
        if (title.endsWith("_[1]")) {
            return -122;
        }
        if (title.contains("::") || title.startsWith("-[") || title.startsWith("+[")) {
            return 4;
        }
        if (title.indexOf(47) > 0 && title.charAt(0) != '[' || title.indexOf(46) > 0 && Character.isUpperCase(title.charAt(0))) {
            return 1;
        }
        return 3;
    }

    private static boolean isThreadFrame(String name, byte type) {
        return type == 3 && name.startsWith("[") && TID_FRAME_PATTERN.matcher(name).matches();
    }

    private static int getCommonPrefix(String a, String b) {
        int length = Math.min(a.length(), b.length());
        for (int i = 0; i < length; ++i) {
            if (a.charAt(i) == b.charAt(i) && a.charAt(i) <= '\u007f') continue;
            return i;
        }
        return length;
    }

    private static String escape(String s) {
        if (s.indexOf(92) >= 0) {
            s = s.replace("\\", "\\\\");
        }
        if (s.indexOf(39) >= 0) {
            s = s.replace("'", "\\'");
        }
        return s;
    }

    private static String unescape(String s) {
        if (s.indexOf(39) >= 0) {
            s = s.replace("\\'", "'");
        }
        if (s.indexOf(92) >= 0) {
            s = s.replace("\\\\", "\\");
        }
        return s;
    }

    @Override
    public int compare(Frame f1, Frame f2) {
        return this.order[f1.getTitleIndex()] - this.order[f2.getTitleIndex()];
    }

    public static void convert(String input, String output, Arguments args) throws IOException {
        FlameGraph fg = new FlameGraph(args);
        try (InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(input), StandardCharsets.UTF_8);){
            if (input.endsWith(".html")) {
                fg.parseHtml(in);
            } else {
                fg.parseCollapsed(in);
            }
        }
        try (PrintStream out = new PrintStream(output, "UTF-8");){
            fg.dump(out);
        }
    }
}

