/*
 * Decompiled with CFR 0.152.
 */
package one.convert;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import one.convert.Arguments;
import one.convert.CallStack;
import one.convert.Classifier;
import one.convert.FlameGraph;
import one.convert.JfrConverter;
import one.jfr.JfrReader;
import one.jfr.StackTrace;
import one.jfr.event.AllocationSample;
import one.jfr.event.Event;

public class JfrToFlame
extends JfrConverter {
    private final FlameGraph fg;

    public JfrToFlame(JfrReader jfr, Arguments args) {
        super(jfr, args);
        this.fg = new FlameGraph(args);
    }

    @Override
    protected void convertChunk() {
        this.collector.forEach(new JfrConverter.AggregatedEventVisitor(){
            final CallStack stack;
            {
                this.stack = new CallStack();
            }

            @Override
            public void visit(Event event, long value) {
                StackTrace stackTrace = JfrToFlame.this.jfr.stackTraces.get(event.stackTraceId);
                if (stackTrace != null) {
                    Arguments args = JfrToFlame.this.args;
                    long[] methods = stackTrace.methods;
                    byte[] types = stackTrace.types;
                    int[] locations = stackTrace.locations;
                    if (args.threads) {
                        this.stack.push(JfrToFlame.this.getThreadName(event.tid), (byte)3);
                    }
                    if (args.classify) {
                        Classifier.Category category = JfrToFlame.this.getCategory(stackTrace);
                        this.stack.push(category.title, category.type);
                    }
                    int i = methods.length;
                    while (--i >= 0) {
                        int location;
                        String methodName = JfrToFlame.this.getMethodName(methods[i], types[i]);
                        if (args.lines && (location = locations[i] >>> 16) != 0) {
                            methodName = methodName + ":" + location;
                        } else if (args.bci && (location = locations[i] & 0xFFFF) != 0) {
                            methodName = methodName + "@" + location;
                        }
                        this.stack.push(methodName, types[i]);
                    }
                    long classId = event.classId();
                    if (classId != 0L) {
                        this.stack.push(JfrToFlame.this.getClassName(classId), (byte)(event instanceof AllocationSample && ((AllocationSample)event).tlabSize == 0L ? 5 : 2));
                    }
                    JfrToFlame.this.fg.addSample(this.stack, value);
                    this.stack.clear();
                }
            }
        });
    }

    public void dump(OutputStream out) throws IOException {
        try (PrintStream ps = new PrintStream(out, false, "UTF-8");){
            this.fg.dump(ps);
        }
    }

    public static void convert(String input, String output, Arguments args) throws IOException {
        JfrToFlame converter;
        try (JfrReader jfr = new JfrReader(input);){
            converter = new JfrToFlame(jfr, args);
            converter.convert();
        }
        try (FileOutputStream out = new FileOutputStream(output);){
            converter.dump(out);
        }
    }
}

