/*
 * Decompiled with CFR 0.152.
 */
package one.converter;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import one.convert.Arguments;
import one.convert.FlameGraph;
import one.convert.JfrToFlame;
import one.convert.JfrToHeatmap;
import one.convert.JfrToPprof;

public class Main {
    public static void main(String[] argv) throws Exception {
        Arguments args = new Arguments(argv);
        if (args.help || args.files.isEmpty()) {
            Main.usage();
            return;
        }
        if (args.files.size() == 1) {
            args.files.add(".");
        }
        int fileCount = args.files.size() - 1;
        String lastFile = args.files.get(fileCount);
        boolean isDirectory = new File(lastFile).isDirectory();
        if (args.output == null) {
            int ext;
            args.output = !isDirectory && (ext = lastFile.lastIndexOf(46)) > 0 ? lastFile.substring(ext + 1) : "html";
        }
        for (int i = 0; i < fileCount; ++i) {
            String input = args.files.get(i);
            String output = isDirectory ? new File(lastFile, Main.replaceExt(input, args.output)).getPath() : lastFile;
            System.out.print("Converting " + Main.getFileName(input) + " -> " + Main.getFileName(output) + " ");
            System.out.flush();
            long startTime = System.nanoTime();
            Main.convert(input, output, args);
            long endTime = System.nanoTime();
            System.out.print("# " + (double)((endTime - startTime) / 1000000L) / 1000.0 + " s\n");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void convert(String input, String output, Arguments args) throws IOException {
        if (Main.isJfr(input)) {
            if ("html".equals(args.output) || "collapsed".equals(args.output)) {
                JfrToFlame.convert(input, output, args);
                return;
            } else if ("pprof".equals(args.output) || "pb".equals(args.output) || args.output.endsWith("gz")) {
                JfrToPprof.convert(input, output, args);
                return;
            } else {
                if (!"heatmap".equals(args.output)) throw new IllegalArgumentException("Unrecognized output format: " + args.output);
                JfrToHeatmap.convert(input, output, args);
            }
            return;
        } else {
            FlameGraph.convert(input, output, args);
        }
    }

    private static String getFileName(String fileName) {
        return fileName.substring(fileName.lastIndexOf(File.separatorChar) + 1);
    }

    private static String replaceExt(String fileName, String output) {
        String ext = "heatmap".equals(output) ? "html" : output;
        int slash = fileName.lastIndexOf(File.separatorChar);
        int dot = fileName.lastIndexOf(46);
        return dot > slash ? fileName.substring(slash + 1, dot + 1) + ext : fileName.substring(slash + 1) + '.' + ext;
    }

    private static boolean isJfr(String fileName) throws IOException {
        if (fileName.endsWith(".jfr")) {
            return true;
        }
        if (fileName.endsWith(".collapsed") || fileName.endsWith(".txt") || fileName.endsWith(".csv")) {
            return false;
        }
        byte[] buf = new byte[4];
        try (FileInputStream fis = new FileInputStream(fileName);){
            boolean bl = fis.read(buf) == 4 && buf[0] == 70 && buf[1] == 76 && buf[2] == 82 && buf[3] == 0;
            return bl;
        }
    }

    private static void usage() {
        System.out.print("Usage: java -jar ap-loader.jar jfrconv [options] <input> [<input>...] <output>\n\nConversion options:\n  -o --output FORMAT    Output format: html, collapsed, pprof, pb.gz, heatmap\n\nJFR options:\n     --cpu              CPU profile\n     --wall             Wall clock profile\n     --alloc            Allocation profile\n     --live             Live object profile\n     --nativemem        malloc profile\n     --leak             Only include memory leaks in nativemem\n     --lock             Lock contention profile\n  -t --threads          Split stack traces by threads\n  -s --state LIST       Filter thread states: runnable, sleeping\n     --classify         Classify samples into predefined categories\n     --total            Accumulate total value (time, bytes, etc.)\n     --lines            Show line numbers\n     --bci              Show bytecode indices\n     --simple           Simple class names instead of FQN\n     --norm             Normalize names of hidden classes / lambdas\n     --dot              Dotted class names\n     --from TIME        Start time in ms (absolute or relative)\n     --to TIME          End time in ms (absolute or relative)\n\nFlame Graph options:\n     --title STRING     Flame Graph title\n     --minwidth X       Skip frames smaller than X%\n     --grain X          Coarsen Flame Graph to the given grain size\n     --skip N           Skip N bottom frames\n  -r --reverse          Reverse stack traces (defaults to icicle graph)\n  -i --inverted         Toggles the layout for reversed stacktraces from icicle to flamegraph\n                        and for default stacktraces from flamegraph to icicle\n  -I --include REGEX    Include only stacks with the specified frames\n  -X --exclude REGEX    Exclude stacks with the specified frames\n     --highlight REGEX  Highlight frames matching the given pattern\n");
    }
}

