/*
 * Decompiled with CFR 0.152.
 */
package one.heatmap;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Comparator;
import one.convert.Arguments;
import one.convert.Index;
import one.convert.JfrConverter;
import one.convert.ResourceProcessor;
import one.heatmap.HtmlOut;
import one.heatmap.HuffmanEncoder;
import one.heatmap.LzNodeTree;
import one.heatmap.Method;
import one.heatmap.MethodCache;
import one.heatmap.SampleList;
import one.heatmap.StackStorage;
import one.heatmap.SynonymTable;
import one.jfr.DictionaryInt;

public class Heatmap {
    public static final int BLOCK_DURATION_MS = 20;
    private final Arguments args;
    private State state;
    private long startMs;

    public Heatmap(Arguments args, JfrConverter converter) {
        this.args = args;
        this.state = new State(converter, 20L);
    }

    public void addEvent(int stackTraceId, int extra, byte type, long timeMs) {
        this.state.addEvent(stackTraceId, extra, type, timeMs);
    }

    public void addStack(long id, long[] methods, int[] locations, byte[] types, int size) {
        this.state.addStack(id, methods, locations, types, size);
    }

    public void beforeChunk() {
        this.state.methodsCache.clear();
    }

    public void finish(long startMs) {
        this.startMs = startMs;
        this.state.methodsCache.clear();
        this.state.stackTracesCache.clear();
    }

    private EvaluationContext evaluate() {
        State state = this.state;
        this.state = null;
        return new EvaluationContext(state.sampleList.samples(), state.methodsCache.methodsIndex(), state.stackTracesRemap.orderedTraces(), state.methodsCache.orderedSymbolTable());
    }

    private void compressMethods(HtmlOut out, Method[] methods) {
        out.writeVar(methods.length);
        for (Method method : methods) {
            out.writeVar(method.className);
            out.writeVar(method.methodName);
            out.write18(method.location & 0xFFFF);
            out.write18(method.location >>> 16);
            out.write6(method.type);
        }
    }

    public void dump(PrintStream stream) throws IOException {
        if (this.state.sampleList.getRecordsCount() == 0) {
            stream.println("No samples found");
            return;
        }
        EvaluationContext evaluationContext = this.evaluate();
        String tail = ResourceProcessor.getResource("/heatmap.html");
        tail = ResourceProcessor.printTill(stream, tail, "/*executionsHeatmap:*/");
        HtmlOut out = new HtmlOut(stream);
        stream.print('S');
        this.printHeatmap(out, evaluationContext);
        stream.print('E');
        tail = ResourceProcessor.printTill(stream, tail, "/*methods:*/");
        out.reset();
        stream.print('S');
        this.printMethods(out, evaluationContext);
        stream.print('E');
        tail = ResourceProcessor.printTill(stream, tail, "/*title:*/");
        stream.print(this.args.title == null ? "Heatmap" : this.args.title);
        tail = ResourceProcessor.printTill(stream, tail, "/*startMs:*/0");
        stream.print(this.startMs);
        tail = ResourceProcessor.printTill(stream, tail, "/*cpool:*/");
        this.printConstantPool(stream, evaluationContext);
        stream.print(tail);
    }

    private void printHeatmap(HtmlOut out, EvaluationContext context) {
        int veryStart = out.pos();
        int wasPos = out.pos();
        int[] stackChunksBuffer = this.buildLz78TreeAndPrepareData(context);
        this.renameMethodsByFrequency(context);
        this.writeStartMethods(out, context);
        wasPos = this.debugStep("start methods", out, wasPos, veryStart);
        this.writeBlockSizes(out, context);
        wasPos = this.debugStep("stack sizes", out, wasPos, veryStart);
        SynonymTable synonymTable = context.nodeTree.extractSynonymTable();
        synonymTable.calculateSynonyms();
        this.writeSynonymsTable(out, synonymTable);
        wasPos = this.debugStep("tree synonyms", out, wasPos, veryStart);
        this.writeTree(out, synonymTable, context);
        wasPos = this.debugStep("tree body", out, wasPos, veryStart);
        int chunksCount = this.calculateSamplesSynonyms(synonymTable, context, stackChunksBuffer);
        this.writeSynonymsTable(out, synonymTable);
        wasPos = this.debugStep("samples synonyms", out, wasPos, veryStart);
        this.writeSamples(out, synonymTable, context, stackChunksBuffer);
        this.debugStep("samples body", out, wasPos, veryStart);
        this.debug("storage size: " + context.nodeTree.storageSize());
        out.write30(context.nodeTree.nodesCount());
        out.write30(context.sampleList.blockSizes.length);
        out.write30(context.nodeTree.storageSize());
        out.write30(chunksCount);
        out.write30(context.sampleList.stackIds.length);
    }

    private void writeSamples(HtmlOut out, SynonymTable synonymTable, EvaluationContext context, int[] stackChunksBuffer) {
        for (int stackId : context.sampleList.stackIds) {
            int chunksStart = stackChunksBuffer[stackId * 2];
            int chunksEnd = stackChunksBuffer[stackId * 2 + 1];
            for (int i = chunksStart; i < chunksEnd; ++i) {
                int nodeId = stackChunksBuffer[i];
                out.writeVar(synonymTable.nodeIdOrSynonym(nodeId));
            }
        }
    }

    private int calculateSamplesSynonyms(SynonymTable synonymTable, EvaluationContext context, int[] stackChunksBuffer) {
        int chunksCount = 0;
        int[] childrenCount = synonymTable.reset();
        for (int stackId : context.sampleList.stackIds) {
            int chunksStart = stackChunksBuffer[stackId * 2];
            int chunksEnd = stackChunksBuffer[stackId * 2 + 1];
            for (int i = chunksStart; i < chunksEnd; ++i) {
                int n = stackChunksBuffer[i];
                childrenCount[n] = childrenCount[n] - 1;
                ++chunksCount;
            }
        }
        synonymTable.calculateSynonyms();
        return chunksCount;
    }

    private void writeTree(HtmlOut out, SynonymTable synonymTable, EvaluationContext context) {
        long[] data = context.nodeTree.treeData();
        int dataSize = context.nodeTree.treeDataSize();
        for (int i = 0; i < dataSize; ++i) {
            long d = data[i];
            int parentId = context.nodeTree.extractParentId(d);
            int methodId = context.nodeTree.extractMethodId(d);
            out.writeVar(synonymTable.nodeIdOrSynonym(parentId));
            out.writeVar(context.orderedMethods[methodId].frequencyOrNewMethodId);
        }
    }

    private void writeSynonymsTable(HtmlOut out, SynonymTable synonymTable) {
        out.writeVar(synonymTable.synonymsCount());
        for (int i = 0; i < synonymTable.synonymsCount(); ++i) {
            out.writeVar(synonymTable.synonymAt(i));
        }
    }

    private void writeStartMethods(HtmlOut out, EvaluationContext context) {
        int startsCount = 0;
        for (Method method : context.orderedMethods) {
            if (!method.start) continue;
            ++startsCount;
        }
        out.writeVar(startsCount);
        for (Method method : context.orderedMethods) {
            if (!method.start) continue;
            out.writeVar(method.frequencyOrNewMethodId);
        }
    }

    private void renameMethodsByFrequency(EvaluationContext context) {
        Arrays.sort(context.orderedMethods, new Comparator<Method>(){

            @Override
            public int compare(Method o1, Method o2) {
                return Integer.compare(o2.frequencyOrNewMethodId, o1.frequencyOrNewMethodId);
            }
        });
        for (int i = 0; i < context.orderedMethods.length; ++i) {
            Method method = context.orderedMethods[i];
            method.frequencyOrNewMethodId = i + 1;
        }
        context.methods.keys((Method[])context.orderedMethods);
    }

    private int[] buildLz78TreeAndPrepareData(EvaluationContext context) {
        int[] samples = context.sampleList.stackIds;
        int[] stackBuffer = new int[(context.stackTraces.length + 1) * 16];
        for (int i = 0; i < samples.length; ++i) {
            int stackId = samples[i];
            stackBuffer[stackId * 2] = ~i;
        }
        int chunksIterator = context.stackTraces.length * 2 + 1;
        for (int i = 0; i < samples.length; ++i) {
            int stackId = samples[i];
            int current = 0;
            int[] stack = context.stackTraces[stackId];
            if (i == ~stackBuffer[stackId * 2]) {
                stackBuffer[stackId * 2] = chunksIterator;
                for (int methodId : stack) {
                    if ((current = context.nodeTree.appendChild(current, methodId)) != 0) continue;
                    ++context.orderedMethods[methodId].frequencyOrNewMethodId;
                    if (stackBuffer.length == chunksIterator) {
                        stackBuffer = Arrays.copyOf(stackBuffer, chunksIterator + chunksIterator / 2);
                    }
                    int justAppendedId = context.nodeTree.nodesCount() - 1;
                    stackBuffer[chunksIterator++] = justAppendedId;
                    context.nodeTree.markNodeAsLastlyUsed(justAppendedId);
                }
                if (current != 0) {
                    if (stackBuffer.length == chunksIterator) {
                        stackBuffer = Arrays.copyOf(stackBuffer, chunksIterator + chunksIterator / 2);
                    }
                    stackBuffer[chunksIterator++] = current;
                    context.nodeTree.markNodeAsLastlyUsed(current);
                }
                stackBuffer[stackId * 2 + 1] = chunksIterator;
                continue;
            }
            for (int methodId : stack) {
                if ((current = context.nodeTree.appendChild(current, methodId)) != 0) continue;
                ++context.orderedMethods[methodId].frequencyOrNewMethodId;
            }
        }
        context.nodeTree.compactTree(stackBuffer, context.stackTraces.length * 2 + 1, chunksIterator);
        return stackBuffer;
    }

    private void writeBlockSizes(HtmlOut out, EvaluationContext context) {
        int[] blockSizeFrequencies = new int[1024];
        int maxBlockSize = 0;
        for (int n : context.sampleList.blockSizes) {
            if (n >= blockSizeFrequencies.length) {
                blockSizeFrequencies = Arrays.copyOf(blockSizeFrequencies, n * 2);
            }
            int n2 = n;
            blockSizeFrequencies[n2] = blockSizeFrequencies[n2] + 1;
            maxBlockSize = Math.max(maxBlockSize, n);
        }
        HuffmanEncoder encoder = new HuffmanEncoder(blockSizeFrequencies, maxBlockSize);
        long[] decodeTable = encoder.calculateOutputTable();
        out.writeVar(decodeTable.length);
        int maxBits = (int)(decodeTable[decodeTable.length - 1] >>> 56);
        out.writeVar(maxBits);
        for (long l : decodeTable) {
            out.writeVar(l & 0xFFFFFFFFFFFFFFL);
            out.writeVar(l >>> 56);
        }
        for (int blockSize : context.sampleList.blockSizes) {
            if (!encoder.append(blockSize)) continue;
            for (int value : encoder.values) {
                out.nextByte(value);
            }
        }
        if (encoder.flushIfNeed()) {
            for (int value : encoder.values) {
                out.nextByte(value);
            }
        }
    }

    private void printConstantPool(PrintStream out, EvaluationContext evaluationContext) {
        for (String symbol : evaluationContext.symbols) {
            out.print('\"');
            out.print(symbol.replace("\\", "\\\\").replace("\"", "\\\""));
            out.print("\",");
        }
    }

    private void printMethods(HtmlOut out, EvaluationContext evaluationContext) throws IOException {
        this.debug("methods count " + evaluationContext.orderedMethods.length);
        Arrays.sort(evaluationContext.orderedMethods, new Comparator<Method>(){

            @Override
            public int compare(Method o1, Method o2) {
                return Integer.compare(o1.frequencyOrNewMethodId, o2.frequencyOrNewMethodId);
            }
        });
        out.nextByte(65);
        this.compressMethods(out, evaluationContext.orderedMethods);
        out.nextByte(65);
    }

    private int debugStep(String step, HtmlOut out, int wasPos, int veryStartPos) {
        int nowPos = out.pos();
        this.debug(step + " " + (double)(nowPos - wasPos) / 1048576.0 + " MB");
        this.debug(step + " pos in data " + (nowPos - veryStartPos));
        return nowPos;
    }

    private void debug(String text) {
    }

    private static class State {
        private static final int LIMIT = Integer.MAX_VALUE;
        final SampleList sampleList;
        final StackStorage stackTracesRemap = new StackStorage();
        final DictionaryInt stackTracesCache = new DictionaryInt();
        final MethodCache methodsCache;
        int[] cachedStackTrace = new int[4096];

        State(JfrConverter converter, long blockDurationMs) {
            this.sampleList = new SampleList(blockDurationMs);
            this.methodsCache = new MethodCache(converter);
        }

        public void addEvent(int stackTraceId, int extra, byte type, long timeMs) {
            if (this.sampleList.getRecordsCount() >= Integer.MAX_VALUE) {
                return;
            }
            if (extra == 0) {
                this.sampleList.add(this.stackTracesCache.get(stackTraceId), timeMs);
                return;
            }
            int id = this.stackTracesCache.get((long)extra << 32 | (long)stackTraceId, -1);
            if (id != -1) {
                this.sampleList.add(id, timeMs);
                return;
            }
            int prototypeId = this.stackTracesCache.get(stackTraceId);
            int[] prototype = this.stackTracesRemap.get(prototypeId);
            id = this.stackTracesRemap.indexWithPrototype(prototype, this.methodsCache.indexForClass(extra, type));
            this.stackTracesCache.put((long)extra << 32 | (long)stackTraceId, id);
            this.sampleList.add(id, timeMs);
        }

        public void addStack(long id, long[] methods, int[] locations, byte[] types, int size) {
            int[] stackTrace = this.cachedStackTrace;
            if (stackTrace.length < size) {
                this.cachedStackTrace = stackTrace = new int[size * 2];
            }
            for (int i = size - 1; i >= 0; --i) {
                long methodId = methods[i];
                byte type = types[i];
                int location = locations[i];
                int index = size - 1 - i;
                boolean firstMethodInTrace = index == 0;
                stackTrace[index] = this.methodsCache.index(methodId, location, type, firstMethodInTrace);
            }
            this.stackTracesCache.put(id, this.stackTracesRemap.index(stackTrace, size));
        }
    }

    private static class EvaluationContext {
        final Index<Method> methods;
        final Method[] orderedMethods;
        final int[][] stackTraces;
        final String[] symbols;
        final SampleList.Result sampleList;
        final LzNodeTree nodeTree = new LzNodeTree();

        EvaluationContext(SampleList.Result sampleList, Index<Method> methods, int[][] stackTraces, String[] symbols) {
            this.sampleList = sampleList;
            this.methods = methods;
            this.stackTraces = stackTraces;
            this.symbols = symbols;
            this.orderedMethods = methods.keys();
        }
    }
}

