/*
 * Decompiled with CFR 0.152.
 */
package one.heatmap;

import java.io.PrintStream;

public class HtmlOut {
    private final PrintStream out;
    private int pos;

    public HtmlOut(PrintStream out) {
        this.out = out;
    }

    public int pos() {
        return this.pos;
    }

    public void reset() {
        this.pos = 0;
    }

    public void nextByte(int c) {
        switch (c) {
            case 0: {
                c = 127;
                break;
            }
            case 13: {
                c = 126;
                break;
            }
            case 38: {
                c = 125;
                break;
            }
            case 60: {
                c = 124;
                break;
            }
            case 62: {
                c = 123;
            }
        }
        this.out.write(c);
        ++this.pos;
    }

    public void writeVar(long v) {
        while (v >= 61L) {
            int b = 61 + (int)(v % 61L);
            this.nextByte(b);
            v /= 61L;
        }
        this.nextByte((int)v);
    }

    public void write6(int v) {
        if ((v & 0xFFFFFFC0) != 0) {
            throw new IllegalArgumentException("Value " + v + " is out of bounds");
        }
        this.nextByte(v);
    }

    public void write18(int v) {
        if ((v & 0xFFFC0000) != 0) {
            throw new IllegalArgumentException("Value " + v + " is out of bounds");
        }
        for (int i = 0; i < 3; ++i) {
            this.nextByte(v & 0x3F);
            v >>>= 6;
        }
    }

    public void write30(int v) {
        if ((v & 0xC0000000) != 0) {
            throw new IllegalArgumentException("Value " + v + " is out of bounds");
        }
        for (int i = 0; i < 5; ++i) {
            this.nextByte(v & 0x3F);
            v >>>= 6;
        }
    }
}

