/*
 * Decompiled with CFR 0.152.
 */
package one.heatmap;

import java.util.Arrays;
import java.util.PriorityQueue;

public class HuffmanEncoder {
    private final long[] decodeTable;
    private final long[] encodeTable;
    private int data;
    private int bits;
    private static final int MAX_BITS = 27;
    public final int[] values = new int[4];

    public HuffmanEncoder(int[] frequencies, int maxFrequencyIndex) {
        PriorityQueue<Node> minHeap = new PriorityQueue<Node>(maxFrequencyIndex + 1);
        for (int i = 0; i <= maxFrequencyIndex; ++i) {
            int frequency = frequencies[i];
            if (frequency == 0) continue;
            minHeap.add(new Node(frequency, i));
        }
        while (minHeap.size() > 1) {
            Node left = (Node)minHeap.remove();
            Node right = (Node)minHeap.remove();
            minHeap.add(new Node(left, right));
        }
        long[] decodeTable = new long[maxFrequencyIndex + 1];
        ((Node)minHeap.remove()).fillTable(decodeTable, 0L);
        Arrays.sort(decodeTable);
        for (int i = 0; i < decodeTable.length; ++i) {
            if (decodeTable[i] == 0L) continue;
            if (i == 0) break;
            long[] nextDecodeTable = new long[decodeTable.length - i];
            System.arraycopy(decodeTable, i, nextDecodeTable, 0, nextDecodeTable.length);
            decodeTable = nextDecodeTable;
            break;
        }
        this.decodeTable = decodeTable;
        this.encodeTable = new long[maxFrequencyIndex + 1];
        this.encodeTable[(int)decodeTable[0]] = decodeTable[0] & 0xFF00000000000000L;
        long code = 0L;
        for (int i = 1; i < decodeTable.length; ++i) {
            long decodePrev = decodeTable[i - 1];
            long decodeNow = decodeTable[i];
            long prevCount = decodePrev >>> 56;
            long nowCount = decodeNow >>> 56;
            code = code + 1L << (int)(nowCount - prevCount);
            int value = (int)decodeNow;
            this.encodeTable[value] = nowCount << 56 | code;
        }
    }

    public boolean append(int value) {
        boolean hasOverflow = false;
        long v = this.encodeTable[value];
        int bits = (int)(v >>> 56);
        for (long i = 1L << bits - 1; i > 0L; i >>>= 1) {
            this.data = this.data << 1 | ((v & i) == 0L ? 0 : 1);
            if (++this.bits != 27) continue;
            hasOverflow = true;
            this.flush();
        }
        return hasOverflow;
    }

    public boolean flushIfNeed() {
        if (this.bits == 0) {
            return false;
        }
        this.data <<= 27 - this.bits;
        this.flush();
        return true;
    }

    public void flush() {
        this.data = Integer.reverse(this.data) >>> 5;
        this.values[3] = this.data % 123;
        this.data /= 123;
        this.values[2] = this.data % 123;
        this.data /= 123;
        this.values[1] = this.data % 123;
        this.data /= 123;
        this.values[0] = this.data;
        this.data = 0;
        this.bits = 0;
    }

    public long[] calculateOutputTable() {
        return this.decodeTable;
    }

    private static class Node
    implements Comparable<Node> {
        final int frequency;
        final int value;
        Node left;
        Node right;

        Node(int frequency, int value) {
            this.frequency = frequency;
            this.value = value;
        }

        public Node(Node left, Node right) {
            this.left = left;
            this.right = right;
            this.frequency = left.frequency + right.frequency;
            this.value = -1;
        }

        public void fillTable(long[] table, long bitsCount) {
            if (this.value >= 0) {
                table[this.value] = bitsCount | (long)this.value;
                return;
            }
            this.left.fillTable(table, bitsCount + 0x100000000000000L);
            this.right.fillTable(table, bitsCount + 0x100000000000000L);
        }

        @Override
        public int compareTo(Node o) {
            return this.frequency - o.frequency;
        }
    }
}

