/*
 * Decompiled with CFR 0.152.
 */
package one.heatmap;

import java.util.Arrays;
import one.heatmap.SynonymTable;

public class LzNodeTree {
    private static final int INITIAL_CAPACITY = 0x200000;
    private long[] keys = new long[0x200000];
    private int[] values = new int[0x200000];
    private long[] outputData = new long[0x100000];
    private int[] childrenCount = new int[0x100000];
    private long[] lengthToRoot = new long[0x100000];
    private int storageSize = 0;
    private int nodesCount = 1;

    public int appendChild(int parentNode, int methodId) {
        long k;
        long method = (long)methodId << 32;
        long key = method | (long)parentNode;
        int mask = this.keys.length - 1;
        int i = LzNodeTree.hashCode(key) & mask;
        while ((k = this.keys[i]) != 0L) {
            if (k == key) {
                return this.values[i];
            }
            i = i + 1 & mask;
        }
        if (this.nodesCount >= this.outputData.length) {
            this.outputData = Arrays.copyOf(this.outputData, this.nodesCount + this.nodesCount / 2);
            this.childrenCount = Arrays.copyOf(this.childrenCount, this.nodesCount + this.nodesCount / 2);
            this.lengthToRoot = Arrays.copyOf(this.lengthToRoot, this.nodesCount + this.nodesCount / 2);
        }
        this.lengthToRoot[this.nodesCount] = (long)((int)this.lengthToRoot[parentNode] + 1) | (long)parentNode << 32;
        this.outputData[this.nodesCount - 1] = key;
        this.keys[i] = key;
        this.values[i] = this.nodesCount;
        if (this.nodesCount * 2 > this.keys.length) {
            this.resize(this.keys.length * 2);
        }
        ++this.nodesCount;
        int n = parentNode;
        this.childrenCount[n] = this.childrenCount[n] - 1;
        return 0;
    }

    public long[] treeData() {
        return this.outputData;
    }

    public int treeDataSize() {
        return this.nodesCount - 1;
    }

    public int extractParentId(long treeElement) {
        return (int)treeElement;
    }

    public int extractMethodId(long treeElement) {
        return (int)(treeElement >>> 32);
    }

    public void markNodeAsLastlyUsed(int nodeId) {
        long ltr = this.lengthToRoot[nodeId];
        int parent = (int)(ltr >>> 32);
        if (parent >= 0) {
            this.lengthToRoot[nodeId] = ltr | Long.MIN_VALUE;
            do {
                ltr = this.lengthToRoot[parent];
                this.lengthToRoot[parent] = ltr | 0xC000000000000000L;
            } while ((parent = (int)(ltr >>> 32)) > 0);
        }
    }

    public void compactTree(int[] remapAsWell, int fromIndex, int toIndex) {
        int[] mappings = this.values;
        mappings[0] = 0;
        int nodes = 1;
        int storageSize = 0;
        for (int oldNodeID = 1; oldNodeID < this.nodesCount; ++oldNodeID) {
            long ltr = this.lengthToRoot[oldNodeID];
            if (ltr >= 0L) continue;
            if ((ltr & 0x4000000000000000L) == 0L) {
                storageSize += (int)ltr;
            }
            mappings[oldNodeID] = nodes;
            this.childrenCount[nodes] = this.childrenCount[oldNodeID];
            long out = this.outputData[oldNodeID - 1];
            long outMethod = 0xFFFFFFFF00000000L & out;
            int oldParent = (int)out;
            this.outputData[nodes - 1] = outMethod | (long)mappings[oldParent];
            ++nodes;
        }
        for (int i = fromIndex; i < toIndex; ++i) {
            remapAsWell[i] = mappings[remapAsWell[i]];
        }
        this.storageSize = storageSize;
        this.nodesCount = nodes;
    }

    public SynonymTable extractSynonymTable() {
        return new SynonymTable(this.keys, this.childrenCount, this.nodesCount);
    }

    public int storageSize() {
        return this.storageSize;
    }

    public int nodesCount() {
        return this.nodesCount;
    }

    private void resize(int newCapacity) {
        long[] newKeys = new long[newCapacity];
        int[] newValues = new int[newCapacity];
        int mask = newKeys.length - 1;
        block0: for (int i = 0; i < this.keys.length; ++i) {
            if (this.keys[i] == 0L) continue;
            int j = LzNodeTree.hashCode(this.keys[i]) & mask;
            while (true) {
                if (newKeys[j] == 0L) {
                    newKeys[j] = this.keys[i];
                    newValues[j] = this.values[i];
                    continue block0;
                }
                j = j + 1 & mask;
            }
        }
        this.keys = newKeys;
        this.values = newValues;
    }

    private static int hashCode(long key) {
        return (int)((key *= -4132994306676758123L) ^ key >>> 32);
    }
}

