/*
 * Decompiled with CFR 0.152.
 */
package one.jfr.event;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import one.jfr.event.Event;
import one.jfr.event.EventCollector;
import one.jfr.event.MallocEvent;

public class MallocLeakAggregator
implements EventCollector {
    private final EventCollector wrapped;
    private final Map<Long, MallocEvent> addresses;
    private List<MallocEvent> events;

    public MallocLeakAggregator(EventCollector wrapped) {
        this.wrapped = wrapped;
        this.addresses = new HashMap<Long, MallocEvent>();
    }

    @Override
    public void collect(Event e) {
        this.events.add((MallocEvent)e);
    }

    @Override
    public void beforeChunk() {
        this.events = new ArrayList<MallocEvent>();
    }

    @Override
    public void afterChunk() {
        this.events.sort(null);
        for (MallocEvent e : this.events) {
            if (e.size > 0L) {
                this.addresses.put(e.address, e);
                continue;
            }
            this.addresses.remove(e.address);
        }
        this.events = null;
    }

    @Override
    public boolean finish() {
        this.wrapped.beforeChunk();
        for (Event event : this.addresses.values()) {
            this.wrapped.collect(event);
        }
        this.wrapped.afterChunk();
        this.addresses.clear();
        return true;
    }

    @Override
    public void forEach(EventCollector.Visitor visitor) {
        this.wrapped.forEach(visitor);
    }
}

