/*
 * Decompiled with CFR 0.152.
 */
package one.profiler;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.instrument.Instrumentation;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.profiler.AsyncProfiler;

public final class AsyncProfilerLoader {
    private static final String EXTRACTION_PROPERTY_NAME = "ap_loader_extraction_dir";
    private static final String PROFILE_LIB_PROPERTY_FILE_PREFIX = "libs/ap-profile-lib-";
    private static final String PROFILE_SCRIPT_PROPERTY_FILE_PREFIX = "libs/ap-profile-script-";
    private static String versionAndPlatformSuffix;
    private static Path extractedAsyncProfiler;
    private static Path extractedJattach;
    private static Path extractedJfrconv;
    private static Path extractedProfiler;
    private static Path extractionDir;
    private static List<String> availableVersions;
    private static String version;
    private static final Map<String, String> propertyFileFirstLineCache;

    private static String getCurrentJARFileName() {
        String[] pathParts = AsyncProfilerLoader.class.getProtectionDomain().getCodeSource().getLocation().getFile().split("/");
        String last = pathParts[pathParts.length - 1];
        if (last.endsWith(".jar")) {
            return last;
        }
        return null;
    }

    public static void setExtractionDirectory(Path extractionDir) {
        AsyncProfilerLoader.extractionDir = extractionDir;
    }

    public static void setVersion(String version) throws IOException {
        AsyncProfilerLoader.deleteExtractionDirectory();
        AsyncProfilerLoader.version = version;
    }

    public static void deleteExtractionDirectory() throws IOException {
        if (extractionDir != null) {
            try (Stream<Path> stream = Files.walk(AsyncProfilerLoader.getExtractionDirectory(), new FileVisitOption[0]);){
                stream.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
            }
        }
        extractedAsyncProfiler = null;
        extractedJattach = null;
        extractedJfrconv = null;
        extractedProfiler = null;
        extractionDir = null;
    }

    public static Path getExtractionDirectory() throws IOException {
        if (extractionDir == null && Files.notExists(extractionDir = AsyncProfilerLoader.getApplicationsDir().resolve(Paths.get("me.bechberger.ap-loader", AsyncProfilerLoader.getVersion())), new LinkOption[0])) {
            Files.createDirectories(extractionDir, new FileAttribute[0]);
        }
        return extractionDir;
    }

    private static Path getApplicationsDir() {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.startsWith("linux")) {
            String xdgDataHome = System.getenv("XDG_DATA_HOME");
            if (xdgDataHome != null && !xdgDataHome.isEmpty()) {
                return Paths.get(xdgDataHome, new String[0]);
            }
            return Paths.get(System.getProperty("user.home"), ".local", "share");
        }
        if (os.startsWith("macosx") || os.startsWith("mac os x")) {
            return Paths.get(System.getProperty("user.home"), "Library", "Application Support");
        }
        throw new UnsupportedOperationException("Unsupported os " + os);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getVersionAndPlatformSuffix() throws OSNotSupportedException {
        if (versionAndPlatformSuffix != null) return versionAndPlatformSuffix;
        String version = AsyncProfilerLoader.getVersion();
        boolean versionOne = version.startsWith("1.");
        boolean versionThree = version.startsWith("3.");
        String os = System.getProperty("os.name").toLowerCase();
        String arch = System.getProperty("os.arch").toLowerCase();
        if (os.startsWith("linux")) {
            if (arch.equals("arm64") || arch.equals("aarch64")) {
                versionAndPlatformSuffix = version + "-linux-arm64";
                return versionAndPlatformSuffix;
            } else if (arch.equals("x86") && versionOne) {
                versionAndPlatformSuffix = version + "-linux-x86";
                return versionAndPlatformSuffix;
            } else {
                if (!arch.equals("x86_64") && !arch.equals("x64") && !arch.equals("amd64")) throw new OSNotSupportedException("Async-profiler does not work on Linux " + arch);
                versionAndPlatformSuffix = versionThree ? version + "-linux-x64" : (AsyncProfilerLoader.isOnMusl() ? version + "-linux-x64-musl" : version + "-linux-x64");
            }
            return versionAndPlatformSuffix;
        } else {
            if (!os.startsWith("macosx") && !os.startsWith("mac os x")) throw new OSNotSupportedException("Async-profiler does not work on " + os);
            if (versionOne) {
                if (!arch.contains("x86")) {
                    throw new OSNotSupportedException("Async-profiler does not work on MacOS " + arch);
                }
                versionAndPlatformSuffix = version + "-macosx-x86";
                return versionAndPlatformSuffix;
            } else {
                versionAndPlatformSuffix = version + "-macos";
            }
        }
        return versionAndPlatformSuffix;
    }

    public static List<String> getAvailableVersions() {
        if (availableVersions == null) {
            availableVersions = new ArrayList<String>();
            try {
                Enumeration<URL> indexFiles = AsyncProfilerLoader.class.getClassLoader().getResources("libs/ap-version");
                while (indexFiles.hasMoreElements()) {
                    URL indexFile = indexFiles.nextElement();
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(indexFile.openStream()));){
                        String line = reader.readLine();
                        if (line == null) continue;
                        availableVersions.add(line);
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return Collections.emptyList();
            }
        }
        return availableVersions;
    }

    private static String readFirstPropertyFileLine(String file) {
        block8: {
            String string;
            if (propertyFileFirstLineCache.containsKey(file)) {
                return propertyFileFirstLineCache.get(file);
            }
            Enumeration<URL> indexFiles = AsyncProfilerLoader.class.getClassLoader().getResources(file);
            if (!indexFiles.hasMoreElements()) break block8;
            URL indexFile = indexFiles.nextElement();
            BufferedReader reader = new BufferedReader(new InputStreamReader(indexFile.openStream()));
            try {
                String firstLine = reader.readLine().trim();
                propertyFileFirstLineCache.put(file, firstLine);
                string = firstLine;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            reader.close();
            return string;
        }
        throw new AssertionError((Object)("Reading property file " + file + " failed, this should never fail"));
    }

    public static String getVersion() {
        if (version == null) {
            if (AsyncProfilerLoader.getAvailableVersions().size() > 1) {
                throw new IllegalStateException("Multiple versions of async-profiler found: " + AsyncProfilerLoader.getAvailableVersions());
            }
            version = AsyncProfilerLoader.getAvailableVersions().get(0);
        }
        return version;
    }

    private static boolean isOnMusl() {
        try {
            Process process = Runtime.getRuntime().exec(new String[]{"ldd", "--version"});
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            return reader.lines().anyMatch(line -> line.contains("musl"));
        }
        catch (IOException e) {
            return false;
        }
    }

    private static String getAsyncProfilerFileName() throws OSNotSupportedException {
        return AsyncProfilerLoader.readFirstPropertyFileLine(PROFILE_LIB_PROPERTY_FILE_PREFIX + AsyncProfilerLoader.getVersionAndPlatformSuffix());
    }

    private static String getLibrarySuffix(String fileName) {
        for (String suffix : Arrays.asList(".so", ".dylib", ".dll")) {
            if (!fileName.endsWith(suffix)) continue;
            return suffix;
        }
        throw new IllegalStateException("Could not determine library suffix for " + fileName);
    }

    private static String getExtractedAsyncProfilerFile() throws OSNotSupportedException {
        return "lib/libasyncProfiler" + AsyncProfilerLoader.getLibrarySuffix(AsyncProfilerLoader.getAsyncProfilerFileName());
    }

    private static String getJattachFileName() throws OSNotSupportedException {
        return "jattach-" + AsyncProfilerLoader.getVersionAndPlatformSuffix();
    }

    private static String getJfrconvFileName() throws OSNotSupportedException {
        return "jfrconv-" + AsyncProfilerLoader.getVersionAndPlatformSuffix();
    }

    private static String getProfilerFileName() throws OSNotSupportedException {
        return AsyncProfilerLoader.readFirstPropertyFileLine(PROFILE_SCRIPT_PROPERTY_FILE_PREFIX + AsyncProfilerLoader.getVersionAndPlatformSuffix());
    }

    private static boolean hasFileInResources(String fileName) {
        try {
            Enumeration<URL> indexFiles = AsyncProfilerLoader.class.getClassLoader().getResources(fileName);
            return indexFiles.hasMoreElements();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static URL getUrl(String fileName) {
        try {
            Enumeration<URL> indexFiles = AsyncProfilerLoader.class.getClassLoader().getResources("libs/" + fileName);
            if (indexFiles.hasMoreElements()) {
                return indexFiles.nextElement();
            }
            throw new IllegalStateException("Could not find file " + fileName);
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not find file " + fileName, e);
        }
    }

    public static boolean isSupported() {
        try {
            return AsyncProfilerLoader.hasFileInResources(PROFILE_LIB_PROPERTY_FILE_PREFIX + AsyncProfilerLoader.getVersionAndPlatformSuffix());
        }
        catch (OSNotSupportedException e) {
            return false;
        }
    }

    private static Path copyFromResources(String fileName, Path destination) throws IOException {
        if (!AsyncProfilerLoader.isSupported()) {
            throw new IllegalStateException("Async-profiler is not supported on this OS and architecture");
        }
        if (Files.exists(destination, new LinkOption[0])) {
            return destination;
        }
        try {
            URL url = AsyncProfilerLoader.getUrl(fileName);
            try (InputStream in = url.openStream();){
                Files.copy(in, destination, new CopyOption[0]);
            }
            return destination;
        }
        catch (IOException e) {
            throw new IOException("Could not copy file " + fileName + " to " + destination, e);
        }
    }

    public static Path extractCustomLibraryFromResources(ClassLoader classLoader, String fileName) throws IOException {
        return AsyncProfilerLoader.extractCustomLibraryFromResources(classLoader, fileName, null);
    }

    public static Path extractCustomLibraryFromResources(ClassLoader classLoader, String fileName, Path alternativeSource) throws IOException {
        Path realFilePath;
        Enumeration<URL> indexFiles;
        Path filePath = Paths.get(fileName, new String[0]);
        String name = filePath.getFileName().toString();
        if (!name.startsWith("lib")) {
            name = System.mapLibraryName(name);
        }
        if (!(indexFiles = classLoader.getResources((realFilePath = filePath.getParent() == null ? Paths.get(name, new String[0]) : filePath.getParent().resolve(name)).toString())).hasMoreElements()) {
            if (alternativeSource == null) {
                throw new IOException("Could not find library " + fileName + " in resources");
            }
            if (!alternativeSource.toFile().isDirectory()) {
                throw new IOException("Could not find library " + fileName + " in resources and alternative source " + alternativeSource + " is not a directory");
            }
            if (alternativeSource.resolve(realFilePath).toFile().exists()) {
                return alternativeSource.resolve(realFilePath);
            }
            throw new IOException("Could not find library " + fileName + " in resources and alternative source " + alternativeSource + " does not contain " + realFilePath);
        }
        URL url = indexFiles.nextElement();
        Path tempDir = Files.createTempDirectory("ap-loader", new FileAttribute[0]);
        try {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                try (Stream<Path> stream = Files.walk(AsyncProfilerLoader.getExtractionDirectory(), new FileVisitOption[0]);){
                    stream.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }));
        }
        catch (RuntimeException e) {
            throw (IOException)e.getCause();
        }
        Path destination = tempDir.resolve(name);
        try {
            try (InputStream in = url.openStream();){
                Files.copy(in, destination, new CopyOption[0]);
            }
            return destination;
        }
        catch (IOException e) {
            throw new IOException("Could not copy file " + fileName + " to " + destination, e);
        }
    }

    public static Path getJattachPath() throws IOException {
        if (extractedJattach == null) {
            Path path = null;
            try {
                path = AsyncProfilerLoader.copyFromResources(AsyncProfilerLoader.getJattachFileName(), AsyncProfilerLoader.getExtractionDirectory().resolve(AsyncProfilerLoader.getJattachFileName()));
            }
            catch (OSNotSupportedException e) {
                throw new IllegalStateException(e.getMessage());
            }
            if (!path.toFile().setExecutable(true)) {
                throw new IOException("Could not make jattach (" + path + ") executable");
            }
            extractedJattach = path;
        }
        return extractedJattach;
    }

    public static Path getJfrconvPath() throws IOException {
        if (extractedJfrconv == null) {
            Path path = null;
            try {
                path = AsyncProfilerLoader.copyFromResources(AsyncProfilerLoader.getJfrconvFileName(), AsyncProfilerLoader.getExtractionDirectory().resolve(AsyncProfilerLoader.getJfrconvFileName()));
            }
            catch (OSNotSupportedException e) {
                throw new IllegalStateException(e.getMessage());
            }
            if (!path.toFile().setExecutable(true)) {
                throw new IOException("Could not make jfrconv (" + path + ") executable");
            }
            extractedJfrconv = path;
        }
        return extractedJfrconv;
    }

    private static String getExtractedProfilerFile() throws OSNotSupportedException {
        return "bin/" + AsyncProfilerLoader.getProfilerFileName();
    }

    private static Path getProfilerPath() throws IOException {
        if (extractedProfiler == null) {
            Path path;
            try {
                Path extracted = AsyncProfilerLoader.getExtractionDirectory().resolve(AsyncProfilerLoader.getExtractedProfilerFile());
                Files.createDirectories(extracted.getParent(), new FileAttribute[0]);
                path = AsyncProfilerLoader.copyFromResources(AsyncProfilerLoader.getProfilerFileName(), extracted);
            }
            catch (OSNotSupportedException e) {
                throw new IllegalStateException(e.getMessage());
            }
            if (!path.toFile().setExecutable(true)) {
                throw new IOException("Could not make asprof (" + path + ") executable");
            }
            extractedProfiler = path;
        }
        return extractedProfiler;
    }

    public static Path getAsyncProfilerPath() throws IOException {
        if (extractedAsyncProfiler == null) {
            try {
                Path extracted = AsyncProfilerLoader.getExtractionDirectory().resolve(AsyncProfilerLoader.getExtractedAsyncProfilerFile());
                Files.createDirectories(extracted.getParent(), new FileAttribute[0]);
                extractedAsyncProfiler = AsyncProfilerLoader.copyFromResources(AsyncProfilerLoader.getAsyncProfilerFileName(), extracted);
            }
            catch (OSNotSupportedException e) {
                throw new IllegalStateException(e.getMessage());
            }
        }
        return extractedAsyncProfiler;
    }

    private static void ensureAsyncProfilerLoaded() throws IOException {
        AsyncProfilerLoader.getAsyncProfilerPath();
    }

    private static String[] processJattachArgs(String[] args) throws IOException {
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(args));
        if (argList.size() >= 4 && ((String)argList.get(1)).equals("load") && (((String)argList.get(2)).endsWith("libasyncProfiler.so") || ((String)argList.get(2)).endsWith("libasyncProfiler.dylib"))) {
            argList.set(2, AsyncProfilerLoader.getAsyncProfilerPath().toString());
            argList.set(3, "true");
        }
        argList.add(0, AsyncProfilerLoader.getJattachPath().toString());
        return argList.toArray(new String[0]);
    }

    public static ExecutionResult executeJattach(String ... args) throws IOException {
        return AsyncProfilerLoader.executeCommand("jattach", AsyncProfilerLoader.processJattachArgs(args));
    }

    private static void executeJattachInteractively(String[] args) throws IOException {
        AsyncProfilerLoader.executeCommandInteractively("jattach", AsyncProfilerLoader.processJattachArgs(args));
    }

    public static boolean jattach(Path agentPath) {
        return AsyncProfilerLoader.jattach(agentPath, null);
    }

    public static boolean jattach(Path agentPath, String arguments) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(String.valueOf(AsyncProfilerLoader.getProcessId()));
        args.add("load");
        args.add(agentPath.toString());
        args.add("true");
        if (arguments != null) {
            args.add(arguments);
        }
        try {
            AsyncProfilerLoader.executeJattach(args.toArray(new String[0]));
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static String[] processConverterArgs(String[] args) throws IOException {
        ArrayList<String> newArgs = new ArrayList<String>();
        newArgs.add(AsyncProfilerLoader.getJfrconvPath().toString());
        newArgs.addAll(Arrays.asList(args));
        System.out.println(newArgs);
        return newArgs.toArray(new String[0]);
    }

    public static ExecutionResult executeConverter(String ... args) throws IOException {
        return AsyncProfilerLoader.executeCommand("jfrconv", AsyncProfilerLoader.processConverterArgs(args));
    }

    private static void executeConverterInteractively(String[] args) throws IOException {
        AsyncProfilerLoader.executeCommandInteractively("jfrconv", AsyncProfilerLoader.processConverterArgs(args));
    }

    private static String[] getEnv() throws IOException {
        if (AsyncProfilerLoader.getVersion().startsWith("3.")) {
            return new String[0];
        }
        return new String[]{"JATTACH=" + AsyncProfilerLoader.getJattachPath().toString(), "PROFILER=" + AsyncProfilerLoader.getAsyncProfilerPath()};
    }

    private static boolean isShellFile(Path file) {
        boolean bl;
        BufferedReader reader = new BufferedReader(new FileReader(file.toFile()));
        try {
            String firstLine = reader.readLine();
            bl = firstLine != null && firstLine.startsWith("#!");
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return false;
            }
        }
        reader.close();
        return bl;
    }

    private static boolean isPossibleLibraryArgument(String arg) {
        return arg.endsWith(".so") || arg.endsWith(".dylib") || arg.endsWith(".dll");
    }

    private static String[] processProfilerArgs(String[] args) throws IOException {
        int index;
        ArrayList<String> argList = new ArrayList<String>();
        if (AsyncProfilerLoader.isShellFile(AsyncProfilerLoader.getProfilerPath())) {
            argList.add("sh");
        }
        if (AsyncProfilerLoader.getVersion().startsWith("3.") && Arrays.asList(args).contains("--lib") && (index = Arrays.asList(args).indexOf("--lib")) + 1 < args.length && !args[index + 1].startsWith("-") && AsyncProfilerLoader.isPossibleLibraryArgument(args[index + 1])) {
            throw new UnsupportedOperationException("The `--lib path` option is not supported in async-profiler 3.x. Feel free to create an issue at https://github.com/jvm-profiling-tools/ap-loader/issues if you need support for this option.");
        }
        argList.add(AsyncProfilerLoader.getProfilerPath().toString());
        argList.addAll(Arrays.asList(args));
        return argList.toArray(new String[0]);
    }

    public static ExecutionResult executeProfiler(String ... args) throws IOException {
        return AsyncProfilerLoader.executeCommand("asprof", AsyncProfilerLoader.processProfilerArgs(args));
    }

    private static String getApplicationCall() {
        String fileName = AsyncProfilerLoader.getCurrentJARFileName();
        if (fileName == null) {
            return "java -jar ap-loader.jar";
        }
        return "java -jar " + fileName;
    }

    private static String processProfilerOutput(String string) throws IOException {
        return string.replace(AsyncProfilerLoader.getProfilerPath().toString(), AsyncProfilerLoader.getApplicationCall() + " profiler");
    }

    private static void executeProfilerInteractively(String[] args) throws IOException {
        AsyncProfilerLoader.ensureAsyncProfilerLoaded();
        String[] command = AsyncProfilerLoader.processProfilerArgs(args);
        Process proc = Runtime.getRuntime().exec(command, AsyncProfilerLoader.getEnv());
        try (BufferedReader stdout = new BufferedReader(new InputStreamReader(proc.getInputStream()));
             BufferedReader stderr = new BufferedReader(new InputStreamReader(proc.getErrorStream()));){
            String stdoutStr = stdout.lines().collect(Collectors.joining("\n"));
            String stderrStr = stderr.lines().collect(Collectors.joining("\n"));
            int exitCode = proc.waitFor();
            System.out.println(AsyncProfilerLoader.processProfilerOutput(stdoutStr));
            System.err.println(AsyncProfilerLoader.processProfilerOutput(stderrStr));
            if (exitCode != 0) {
                System.exit(exitCode);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            System.exit(1);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static ExecutionResult executeCommand(String name, String[] args) throws IOException {
        Process process = Runtime.getRuntime().exec(args, AsyncProfilerLoader.getEnv());
        try (BufferedReader stdout = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            ExecutionResult executionResult;
            try (BufferedReader stderr = new BufferedReader(new InputStreamReader(process.getErrorStream()));){
                String stdoutStr = stdout.lines().collect(Collectors.joining("\n"));
                String stderrStr = stderr.lines().collect(Collectors.joining("\n"));
                int exitCode = process.waitFor();
                if (exitCode != 0) {
                    throw new IOException(name + " failed with exit code " + exitCode + ", stderr: " + stderrStr + ", stdout: " + stdoutStr);
                }
                executionResult = new ExecutionResult(stdoutStr, stderrStr);
            }
            return executionResult;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(name + " failed because it got interrupted");
        }
    }

    private static void executeCommandInteractively(String name, String[] args) throws IOException {
        String[] envArray;
        ProcessBuilder pb = new ProcessBuilder(args);
        pb.inheritIO();
        Map<String, String> env = pb.environment();
        for (String s : envArray = AsyncProfilerLoader.getEnv()) {
            String[] parts = s.split("=", 2);
            env.put(parts[0], parts[1]);
        }
        Process proc = pb.start();
        try {
            System.exit(proc.waitFor());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(name + " failed because it got interrupted");
        }
    }

    public static AsyncProfiler loadOrNull() {
        try {
            return AsyncProfilerLoader.load();
        }
        catch (IOException | IllegalStateException e) {
            return null;
        }
    }

    public static AsyncProfiler load() throws IOException {
        Class<AsyncProfiler> clazz = AsyncProfiler.class;
        synchronized (AsyncProfiler.class) {
            try {
                // ** MonitorExit[var0] (shouldn't be in output)
                return AsyncProfiler.getInstance(AsyncProfilerLoader.getAsyncProfilerPath().toString());
            }
            catch (UnsatisfiedLinkError e) {
                throw new IllegalStateException("Could not load async-profiler from the extraction directory " + AsyncProfilerLoader.getExtractionDirectory() + ". Please make sure that the extraction directory allows execution. You can specify an alternative using the system property " + EXTRACTION_PROPERTY_NAME + ".", e);
            }
        }
    }

    public static void premain(String agentArgs, Instrumentation instrumentation) {
        AsyncProfilerLoader.agentmain(agentArgs, instrumentation);
    }

    public static int getProcessId() {
        String name = ManagementFactory.getRuntimeMXBean().getName();
        int index = name.indexOf(64);
        if (index < 1) {
            throw new IllegalStateException("Could not get process id from " + name);
        }
        try {
            return Integer.parseInt(name.substring(0, index));
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException("Could not get process id from " + name);
        }
    }

    public static void attach(String arguments) {
        try {
            ArrayList<String> args = new ArrayList<String>();
            args.add(AsyncProfilerLoader.getProcessId() + "");
            args.add("load");
            args.add(AsyncProfilerLoader.getAsyncProfilerPath().toString());
            args.add("true");
            if (arguments != null) {
                args.add(arguments);
            }
            AsyncProfilerLoader.executeJattach(args.toArray(new String[0]));
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not attach to the currentd process", e);
        }
    }

    public static void agentmain(String agentArgs, Instrumentation instrumentation) {
        AsyncProfilerLoader.attach(agentArgs);
    }

    private static void printUsage(PrintStream out) {
        out.println("Usage: " + AsyncProfilerLoader.getApplicationCall() + " <command> [args]");
        out.println("Commands:");
        out.println("  help         show this help");
        if (AsyncProfilerLoader.isSupported()) {
            out.println("  jattach      run the included jattach binary");
            out.println("  profiler     run the included asprof");
            out.println("  agentpath    prints the path of the extracted async-profiler agent");
            out.println("  jattachpath  prints the path of the extracted jattach binary");
        }
        out.println("  supported    fails if this JAR does not include a profiler");
        out.println("               for the current OS and architecture");
        out.println("  converter    run the included converter");
        out.println("  version      version of the included async-profiler");
        out.println("  clear        clear the directory used for storing extracted files");
    }

    private static void checkCommandAvailability(String command) {
        switch (command) {
            case "jattach": 
            case "profiler": 
            case "agentpath": 
            case "jattachpath": {
                if (AsyncProfilerLoader.isSupported()) break;
                System.err.println("The " + command + " command is not supported on this OS and architecture, using this JAR");
                System.exit(1);
                break;
            }
        }
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 0 || args[0].equals("help")) {
            AsyncProfilerLoader.printUsage(System.out);
            return;
        }
        String command = args[0];
        String[] commandArgs = Arrays.copyOfRange(args, 1, args.length);
        AsyncProfilerLoader.checkCommandAvailability(command);
        switch (command) {
            case "jattach": {
                AsyncProfilerLoader.executeJattachInteractively(commandArgs);
                break;
            }
            case "profiler": {
                AsyncProfilerLoader.executeProfilerInteractively(commandArgs);
                break;
            }
            case "agentpath": {
                System.out.println(AsyncProfilerLoader.getAsyncProfilerPath());
                break;
            }
            case "jattachpath": {
                System.out.println(AsyncProfilerLoader.getJattachPath());
                break;
            }
            case "supported": {
                if (AsyncProfilerLoader.isSupported()) break;
                System.exit(1);
                break;
            }
            case "converter": {
                AsyncProfilerLoader.executeConverterInteractively(commandArgs);
                break;
            }
            case "version": {
                System.out.println(AsyncProfilerLoader.getVersion());
                break;
            }
            case "clear": {
                AsyncProfilerLoader.deleteExtractionDirectory();
                break;
            }
            default: {
                System.err.println("Unknown command: " + command);
                System.err.println();
                AsyncProfilerLoader.printUsage(System.err);
            }
        }
    }

    static {
        propertyFileFirstLineCache = new HashMap<String, String>();
        String dir = System.getProperty(EXTRACTION_PROPERTY_NAME, "");
        if (!dir.isEmpty()) {
            Path path = Paths.get(dir, new String[0]);
            if (Files.exists(path, new LinkOption[0])) {
                if (!Files.isDirectory(path, new LinkOption[0])) {
                    throw new IllegalArgumentException("The extraction directory is not a directory: " + dir);
                }
                if (!Files.isWritable(path)) {
                    throw new IllegalArgumentException("The extraction directory is not writable: " + dir);
                }
            }
            extractionDir = path;
        }
    }

    private static class OSNotSupportedException
    extends Exception {
        OSNotSupportedException(String message) {
            super(message);
        }
    }

    public static class ExecutionResult {
        private final String stdout;
        private final String stderr;

        private ExecutionResult(String stdout, String stderr) {
            this.stdout = stdout;
            this.stderr = stderr;
        }

        public String toString() {
            return "ExecutionResult{stdout='" + this.stdout + '\'' + ", stderr='" + this.stderr + '\'' + '}';
        }

        public String getStdout() {
            return this.stdout;
        }

        public String getStderr() {
            return this.stderr;
        }
    }
}

