/*
 * Decompiled with CFR 0.152.
 */
package me.bo0tzz.opennotify4j.bean;

import me.bo0tzz.opennotify4j.bean.Location;

public final class PassLocation
extends Location {
    private final Float altitude;
    private final Integer passes;
    private final Long datetime;

    protected PassLocation(Float latitude, Float longitude, Float altitude, Integer passes, Long datetime) {
        super(latitude, longitude);
        if ((double)altitude.floatValue() < 0.0 || (double)altitude.floatValue() > 10000.0) {
            throw new IllegalArgumentException("Altitude must be between 0.0 and 10,000.0!");
        }
        this.altitude = altitude;
        this.passes = passes;
        this.datetime = datetime;
    }

    public static PassLocationBuilder builder() {
        return new PassLocationBuilder();
    }

    public Float getAltitude() {
        return this.altitude;
    }

    public Integer getPasses() {
        return this.passes;
    }

    public Long getDatetime() {
        return this.datetime;
    }

    @Override
    public String toString() {
        return "PassLocation(altitude=" + this.getAltitude() + ", passes=" + this.getPasses() + ", datetime=" + this.getDatetime() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PassLocation)) {
            return false;
        }
        PassLocation other = (PassLocation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Float this$altitude = this.getAltitude();
        Float other$altitude = other.getAltitude();
        if (this$altitude == null ? other$altitude != null : !((Object)this$altitude).equals(other$altitude)) {
            return false;
        }
        Integer this$passes = this.getPasses();
        Integer other$passes = other.getPasses();
        if (this$passes == null ? other$passes != null : !((Object)this$passes).equals(other$passes)) {
            return false;
        }
        Long this$datetime = this.getDatetime();
        Long other$datetime = other.getDatetime();
        return !(this$datetime == null ? other$datetime != null : !((Object)this$datetime).equals(other$datetime));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PassLocation;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        Float $altitude = this.getAltitude();
        result = result * 59 + ($altitude == null ? 43 : ((Object)$altitude).hashCode());
        Integer $passes = this.getPasses();
        result = result * 59 + ($passes == null ? 43 : ((Object)$passes).hashCode());
        Long $datetime = this.getDatetime();
        result = result * 59 + ($datetime == null ? 43 : ((Object)$datetime).hashCode());
        return result;
    }

    public static class PassLocationBuilder
    extends Location.LocationBuilder {
        private Float latitude;
        private Float longitude;
        private Float altitude;
        private Integer passes;
        private Long datetime;

        PassLocationBuilder() {
        }

        @Override
        public PassLocationBuilder latitude(Float latitude) {
            this.latitude = latitude;
            return this;
        }

        @Override
        public PassLocationBuilder longitude(Float longitude) {
            this.longitude = longitude;
            return this;
        }

        public PassLocationBuilder altitude(Float altitude) {
            this.altitude = altitude;
            return this;
        }

        public PassLocationBuilder passes(Integer passes) {
            this.passes = passes;
            return this;
        }

        public PassLocationBuilder datetime(Long datetime) {
            this.datetime = datetime;
            return this;
        }

        @Override
        public PassLocation build() {
            return new PassLocation(this.latitude, this.longitude, this.altitude, this.passes, this.datetime);
        }

        @Override
        public String toString() {
            return "PassLocation.PassLocationBuilder(latitude=" + this.latitude + ", longitude=" + this.longitude + ", altitude=" + this.altitude + ", passes=" + this.passes + ", datetime=" + this.datetime + ")";
        }
    }
}

