/*
 * Decompiled with CFR 0.152.
 */
package me.ccampo.maven.git.version.plugin;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import me.ccampo.maven.git.version.core.VersionException;
import me.ccampo.maven.git.version.core.strategy.VersionStrategy;
import me.ccampo.maven.git.version.plugin.util.GroupArtifactVersion;
import me.ccampo.maven.git.version.plugin.util.ModelProvider;
import me.ccampo.maven.git.version.plugin.util.PluginConfig;
import me.ccampo.maven.git.version.plugin.util.PluginConfigProvider;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;

@Component(role=AbstractMavenLifecycleParticipant.class, hint="version-inference")
public class VersionInferenceExtension
extends AbstractMavenLifecycleParticipant {
    @Requirement
    private Logger logger;
    @Requirement
    private PlexusContainer container;
    private Map<GroupArtifactVersion, String> projectGavs = new HashMap<GroupArtifactVersion, String>();
    private PluginConfigProvider pluginConfigProvider;
    private ModelProvider modelProvider;

    public void afterProjectsRead(MavenSession session) throws MavenExecutionException {
        this.init();
        for (MavenProject mavenProject : session.getAllProjects()) {
            this.setProjectVersion(mavenProject);
        }
        for (MavenProject mavenProject : session.getAllProjects()) {
            PluginConfig pluginConfig = this.pluginConfigProvider.getForProject(mavenProject);
            if (pluginConfig == null) continue;
            if (pluginConfig.shouldUpdateDependencies) {
                this.setDependencyVersions(mavenProject);
            }
            this.setParentVersion(mavenProject);
            this.createNewVersionPom(mavenProject);
        }
    }

    private void init() {
        Objects.requireNonNull(this.logger);
        Objects.requireNonNull(this.container);
        if (this.pluginConfigProvider == null) {
            this.pluginConfigProvider = new PluginConfigProvider(this.container);
        }
        if (this.modelProvider == null) {
            this.modelProvider = new ModelProvider();
        }
        if (this.projectGavs == null) {
            this.projectGavs = new HashMap<GroupArtifactVersion, String>();
        }
    }

    private void setProjectVersion(MavenProject mavenProject) throws MavenExecutionException {
        PluginConfig pluginConfig = this.pluginConfigProvider.getForProject(mavenProject);
        if (pluginConfig != null) {
            String oldVersion = mavenProject.getVersion();
            String newVersion = this.getNewVersion(pluginConfig.versionStrategy, mavenProject);
            this.logger.info("Inferred project version: " + newVersion);
            String oldFinalName = mavenProject.getBuild().getFinalName();
            String newFinalName = oldFinalName.replaceFirst(Pattern.quote(oldVersion), newVersion);
            this.logger.info("Inferred project.build.finalName: " + newFinalName);
            mavenProject.setVersion(newVersion);
            mavenProject.getArtifact().setVersion(newVersion);
            VersionRange versionRange = VersionRange.createFromVersion((String)newVersion);
            mavenProject.getArtifact().setVersionRange(versionRange);
            mavenProject.getBuild().setFinalName(newFinalName);
            GroupArtifactVersion oldProjectVersion = GroupArtifactVersion.of(mavenProject.getGroupId(), mavenProject.getArtifactId(), oldVersion);
            this.projectGavs.put(oldProjectVersion, newVersion);
        }
    }

    private void setDependencyVersions(MavenProject mavenProject) {
        GroupArtifactVersion projectGav = GroupArtifactVersion.fromMavenProject(mavenProject);
        mavenProject.getDependencies().forEach(dependency -> {
            GroupArtifactVersion dependencyGav = GroupArtifactVersion.of(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion());
            if (!projectGav.equals(dependencyGav) && this.projectGavs.containsKey(dependencyGav)) {
                String newVersion = this.projectGavs.get(dependencyGav);
                dependency.setVersion(newVersion);
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Setting project " + projectGav + " dependency " + dependencyGav + " to version " + newVersion);
                }
            }
        });
    }

    private void setParentVersion(MavenProject mavenProject) throws MavenExecutionException {
        GroupArtifactVersion parentGav;
        String newVersionForParent;
        Model model = this.modelProvider.getModel(mavenProject);
        model.setVersion(mavenProject.getVersion());
        if (model.getParent() != null && (newVersionForParent = this.projectGavs.get(parentGav = GroupArtifactVersion.of(model.getParent().getGroupId(), model.getParent().getArtifactId(), model.getParent().getVersion()))) != null) {
            model.getParent().setVersion(newVersionForParent);
        }
        if (mavenProject.getParent() == null) {
            return;
        }
        MavenProject parent = mavenProject.getParent();
        if (this.projectGavs.containsKey(GroupArtifactVersion.fromMavenProject(parent))) {
            this.logger.warn("Need to update parent (not implemented)");
        }
    }

    private String getNewVersion(VersionStrategy strategy, MavenProject mavenProject) throws MavenExecutionException {
        Optional<String> newVersion;
        try {
            newVersion = Optional.ofNullable(strategy.getVersion(mavenProject));
        }
        catch (VersionException e) {
            throw new MavenExecutionException(e.getMessage(), (Throwable)e);
        }
        return newVersion.orElseThrow(() -> {
            String msg = "Unable to infer new version; strategy returned null.";
            return new MavenExecutionException("Unable to infer new version; strategy returned null.", mavenProject.getFile());
        }).trim();
    }

    private void createNewVersionPom(MavenProject mavenProject) throws MavenExecutionException {
        File newPom;
        PluginConfig pluginConfig = this.pluginConfigProvider.getForProject(mavenProject);
        try {
            newPom = pluginConfig.shouldGenerateTemporaryFile ? File.createTempFile("pom", ".version-inference") : new File(mavenProject.getBasedir(), "pom.xml.new-version");
        }
        catch (IOException e) {
            throw new MavenExecutionException(e.getMessage(), (Throwable)e);
        }
        if (pluginConfig.shouldDeleteTemporaryFile) {
            newPom.deleteOnExit();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(VersionInferenceExtension.class.getSimpleName() + ": using new pom file => " + newPom);
        }
        Model model = this.modelProvider.getModel(mavenProject);
        try (FileWriter fileWriter = new FileWriter(newPom);){
            new MavenXpp3Writer().write((Writer)fileWriter, model);
        }
        catch (IOException e) {
            throw new MavenExecutionException(e.getMessage(), (Throwable)e);
        }
        mavenProject.setFile(newPom);
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void setContainer(PlexusContainer container) {
        this.container = container;
    }

    public void setProjectGavs(Map<GroupArtifactVersion, String> projectGavs) {
        this.projectGavs = projectGavs;
    }

    public void setPluginConfigProvider(PluginConfigProvider pluginConfigProvider) {
        this.pluginConfigProvider = pluginConfigProvider;
    }

    public void setModelProvider(ModelProvider modelProvider) {
        this.modelProvider = modelProvider;
    }
}

