/*
 * Decompiled with CFR 0.152.
 */
package me.ccampo.maven.git.version.plugin.util;

import java.util.Objects;
import org.apache.maven.project.MavenProject;

public class GroupArtifactVersion {
    public final String groupId;
    public final String artifactId;
    public final String version;

    GroupArtifactVersion(String groupId, String artifactId, String version) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
    }

    public static GroupArtifactVersion of(String groupId, String artifactId, String version) {
        return new GroupArtifactVersion(groupId, artifactId, version);
    }

    public static GroupArtifactVersion fromMavenProject(MavenProject mavenProject) {
        return GroupArtifactVersion.of(mavenProject.getGroupId(), mavenProject.getArtifactId(), mavenProject.getVersion());
    }

    public boolean equals(Object o) {
        boolean artifactIdEquals;
        boolean groupIdEquals;
        if (this == o) {
            return true;
        }
        if (!(o instanceof GroupArtifactVersion)) {
            return false;
        }
        GroupArtifactVersion that = (GroupArtifactVersion)o;
        boolean bl = this.groupId == null ? that.groupId == null : (groupIdEquals = this.groupId.equalsIgnoreCase(that.groupId));
        boolean bl2 = this.artifactId == null ? that.artifactId == null : (artifactIdEquals = this.artifactId.equalsIgnoreCase(that.artifactId));
        boolean versionEquals = this.version == null ? that.version == null : this.version.equalsIgnoreCase(that.version);
        return groupIdEquals && artifactIdEquals && versionEquals;
    }

    public int hashCode() {
        return Objects.hash(this.groupId, this.artifactId, this.version);
    }

    public String toString() {
        return this.groupId + ":" + this.artifactId + ":" + this.version;
    }
}

