/*
 * Decompiled with CFR 0.152.
 */
package me.ccampo.maven.git.version.plugin.util;

import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class ModelProvider {
    private final Map<MavenProject, Model> models;

    public ModelProvider(Map<MavenProject, Model> models) {
        this.models = models;
    }

    public ModelProvider() {
        this(new HashMap<MavenProject, Model>());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Model getModel(MavenProject mavenProject) throws MavenExecutionException {
        if (this.models.containsKey(mavenProject)) {
            return this.models.get(mavenProject);
        }
        try (FileReader fileReader = new FileReader(mavenProject.getFile());){
            Model model = new MavenXpp3Reader().read((Reader)fileReader);
            this.models.put(mavenProject, model);
            Model model2 = model;
            return model2;
        }
        catch (IOException | XmlPullParserException e) {
            throw new MavenExecutionException(e.getMessage(), e);
        }
    }
}

