/*
 * Decompiled with CFR 0.152.
 */
package me.ccampo.maven.git.version.plugin.util;

import java.util.HashMap;
import java.util.Map;
import me.ccampo.maven.git.version.plugin.util.PluginConfig;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.PlexusContainer;

public class PluginConfigProvider {
    private final Map<MavenProject, PluginConfig> projectConfigs;
    private final PlexusContainer container;

    public PluginConfigProvider(Map<MavenProject, PluginConfig> projectConfigs, PlexusContainer container) {
        this.projectConfigs = projectConfigs;
        this.container = container;
    }

    public PluginConfigProvider(PlexusContainer container) {
        this(new HashMap<MavenProject, PluginConfig>(), container);
    }

    public PluginConfig getForProject(MavenProject mavenProject) throws MavenExecutionException {
        if (this.projectConfigs.containsKey(mavenProject)) {
            return this.projectConfigs.get(mavenProject);
        }
        PluginConfig pluginConfig = PluginConfig.of(mavenProject, this.container);
        this.projectConfigs.put(mavenProject, pluginConfig);
        return pluginConfig;
    }
}

