/*
 * Decompiled with CFR 0.152.
 */
package me.chenhe.wearvision.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Xfermode;
import me.chenhe.wearvision.widget.EdgeEffect;

public class ClassicEdgeEffect
extends EdgeEffect {
    private static final String TAG = "ClassicEdgeEffect";
    private static final double ANGLE = 0.5235987755982988;
    private static final float SIN = (float)Math.sin(0.5235987755982988);
    private static final float COS = (float)Math.cos(0.5235987755982988);
    private final Paint mPaint = new Paint();
    private float mRadius;
    private float mBaseGlowScale;

    public ClassicEdgeEffect(Context context) {
        super(context);
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_ATOP));
        this.updatePaint();
    }

    private void updatePaint() {
        int themeColor = this.getColor();
        this.mPaint.setColor(themeColor & 0xFFFFFF | 0x33000000);
    }

    @Override
    public void setSize(int width, int height) {
        float r = (float)width * 0.75f / SIN;
        float y = COS * r;
        float h = r - y;
        float or = (float)height * 0.75f / SIN;
        float oy = COS * or;
        float oh = or - oy;
        this.mRadius = r;
        this.mBaseGlowScale = h > 0.0f ? Math.min(oh / h, 1.0f) : 1.0f;
        Rect bounds = this.getBounds();
        bounds.set(bounds.left, bounds.top, width, (int)Math.min((float)height, h));
    }

    @Override
    public void setColor(int color) {
        super.setColor(color);
        this.updatePaint();
    }

    @Override
    public void onDraw(Canvas canvas) {
        int count = canvas.save();
        Rect bounds = this.getBounds();
        float centerX = bounds.centerX();
        float centerY = (float)bounds.height() - this.mRadius;
        canvas.scale(1.0f, Math.min(this.getGlowScaleY(), 1.0f) * this.mBaseGlowScale, centerX, 0.0f);
        float displacement = Math.max(0.0f, Math.min(this.getDisplacement(), 1.0f)) - 0.5f;
        float translateX = (float)bounds.width() * displacement / 2.0f;
        canvas.clipRect(bounds);
        canvas.translate(translateX, 0.0f);
        this.mPaint.setAlpha((int)(127.0f * this.getGlowAlpha()));
        canvas.drawCircle(centerX, centerY, this.mRadius, this.mPaint);
        canvas.restoreToCount(count);
    }
}

