/*
 * Decompiled with CFR 0.152.
 */
package me.chenhe.wearvision.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RadialGradient;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.Xfermode;
import me.chenhe.wearvision.widget.EdgeEffect;

public class CrescentEdgeEffect
extends EdgeEffect {
    private static final String TAG = "CrescentEdgeEffect";
    private static final float GLOW_SCALE = 0.15f;
    private static final float CRESCENT_EDGE_STOP = 0.7692308f;
    private static final float CRESCENT_EDGE_MIDDLE_STOP = 0.95384616f;
    private final Paint mPaint = new Paint();
    private float mGlowCenterX;
    private float mGlowCenterY;
    private float mGlowRadius;

    public CrescentEdgeEffect(Context context) {
        super(context);
        this.mPaint.setColor(0);
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_ATOP));
    }

    @Override
    public void setSize(int width, int height) {
        Rect bounds = this.getBounds();
        if (width == bounds.width() && height == bounds.height()) {
            return;
        }
        super.setSize(width, height);
        int size = Math.max(bounds.width(), bounds.height());
        float halfSize = (float)size * 0.5f;
        this.mGlowRadius = halfSize / 0.7692308f;
        this.mGlowCenterX = (float)bounds.width() * 0.5f;
        this.mGlowCenterY = this.mGlowRadius;
        this.updatePaint();
    }

    @Override
    public void setColor(int color) {
        if (color == this.getColor()) {
            return;
        }
        super.setColor(color);
        this.updatePaint();
    }

    private void updatePaint() {
        int deepColor = this.getColor() & 0xFFFFFF | 0xFF000000;
        int middleColor = this.getColor() & 0xFFFFFF | 0x7F000000;
        RadialGradient radialGradient = new RadialGradient(this.mGlowCenterX, this.mGlowCenterY, this.mGlowRadius, new int[]{0, 0, middleColor, deepColor}, new float[]{0.0f, 0.7692308f, 0.95384616f, 1.0f}, Shader.TileMode.CLAMP);
        this.mPaint.setShader((Shader)radialGradient);
    }

    @Override
    public void onDraw(Canvas canvas) {
        Rect bounds = this.getBounds();
        float scaleY = Math.min(this.getGlowScaleY(), 1.0f);
        float edgeHeight = (float)bounds.height() * 0.15f;
        float displacement = Math.max(0.0f, Math.min(this.getDisplacement(), 1.0f)) - 0.5f;
        float translateX = (float)bounds.width() * displacement / 2.0f;
        float translateY = -edgeHeight * (1.0f - scaleY);
        int count = canvas.save();
        canvas.clipRect(bounds);
        canvas.translate(translateX, translateY);
        this.mPaint.setAlpha((int)(255.0f * this.getGlowAlpha()));
        canvas.drawCircle(this.mGlowCenterX, this.mGlowCenterY, this.mGlowRadius, this.mPaint);
        canvas.restoreToCount(count);
    }
}

