/*
 * Decompiled with CFR 0.152.
 */
package me.chenhe.wearvision.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.view.animation.AnimationUtils;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import me.chenhe.wearvision.R;

public abstract class EdgeEffect {
    private static final String TAG = "ClassicEdgeEffect";
    private static final int RECEDE_TIME = 600;
    private static final int PULL_TIME = 167;
    private static final int PULL_DECAY_TIME = 2000;
    private static final float MAX_ALPHA = 1.0f;
    private static final float MAX_GLOW_SCALE = 2.0f;
    private static final float PULL_GLOW_BEGIN = 0.0f;
    private static final int MIN_VELOCITY = 100;
    private static final int MAX_VELOCITY = 10000;
    private static final float EPSILON = 0.001f;
    private static final int STATE_IDLE = 0;
    private static final int STATE_PULL = 1;
    private static final int STATE_ABSORB = 2;
    private static final int STATE_RECEDE = 3;
    private static final int STATE_PULL_DECAY = 4;
    private static final float PULL_DISTANCE_ALPHA_GLOW_FACTOR = 0.8f;
    private static final int VELOCITY_GLOW_FACTOR = 6;
    private final Interpolator mInterpolator;
    private final Rect mBounds = new Rect();
    private float mGlowAlpha;
    private float mGlowScaleY;
    private int mGlowColor;
    private float mGlowAlphaStart;
    private float mGlowAlphaFinish;
    private float mGlowScaleYStart;
    private float mGlowScaleYFinish;
    private long mStartTime;
    private float mDuration;
    private int mState = 0;
    private float mPullDistance;
    private float mDisplacement = 0.5f;
    private float mTargetDisplacement = 0.5f;

    public EdgeEffect(Context context) {
        TypedArray a = context.obtainStyledAttributes(R.styleable.EdgeEffect);
        int themeColor = a.getColor(R.styleable.EdgeEffect_android_colorEdgeEffect, -10066330);
        a.recycle();
        this.mGlowColor = themeColor;
        this.mInterpolator = new DecelerateInterpolator();
    }

    public void setSize(int width, int height) {
        this.mBounds.set(0, 0, width, height);
    }

    public boolean isFinished() {
        return this.mState == 0;
    }

    public void finish() {
        this.mState = 0;
    }

    public void onPull(float deltaDistance) {
        this.onPull(deltaDistance, 0.5f);
    }

    public void onPull(float deltaDistance, float displacement) {
        long now = AnimationUtils.currentAnimationTimeMillis();
        this.mTargetDisplacement = displacement;
        if (this.mState == 4 && (float)(now - this.mStartTime) < this.mDuration) {
            return;
        }
        if (this.mState != 1) {
            this.mGlowScaleY = Math.max(0.0f, this.mGlowScaleY);
        }
        this.mState = 1;
        this.mStartTime = now;
        this.mDuration = 167.0f;
        this.mPullDistance += deltaDistance;
        float absdd = Math.abs(deltaDistance);
        this.mGlowAlpha = this.mGlowAlphaStart = Math.min(1.0f, this.mGlowAlpha + absdd * 0.8f);
        if (this.mPullDistance == 0.0f) {
            this.mGlowScaleYStart = 0.0f;
            this.mGlowScaleY = 0.0f;
        } else {
            float scale;
            this.mGlowScaleY = this.mGlowScaleYStart = (scale = Math.max(0.0f, 1.0f - 1.0f / (float)Math.sqrt(Math.abs(this.mPullDistance) * (float)this.mBounds.height()) - 0.3f) / 0.7f);
        }
        this.mGlowAlphaFinish = this.mGlowAlpha;
        this.mGlowScaleYFinish = this.mGlowScaleY;
    }

    public void onRelease() {
        this.mPullDistance = 0.0f;
        if (this.mState != 1 && this.mState != 4) {
            return;
        }
        this.mState = 3;
        this.mGlowAlphaStart = this.mGlowAlpha;
        this.mGlowScaleYStart = this.mGlowScaleY;
        this.mGlowAlphaFinish = 0.0f;
        this.mGlowScaleYFinish = 0.0f;
        this.mStartTime = AnimationUtils.currentAnimationTimeMillis();
        this.mDuration = 600.0f;
    }

    public void onAbsorb(int velocity) {
        this.mState = 2;
        velocity = Math.min(Math.max(100, Math.abs(velocity)), 10000);
        this.mStartTime = AnimationUtils.currentAnimationTimeMillis();
        this.mDuration = 0.15f + (float)velocity * 0.02f;
        this.mGlowAlphaStart = 0.3f;
        this.mGlowScaleYStart = Math.max(this.mGlowScaleY, 0.0f);
        this.mGlowScaleYFinish = Math.min(0.025f + (float)velocity * ((float)velocity / 100.0f) * 1.5E-4f / 2.0f, 1.0f);
        this.mGlowAlphaFinish = Math.max(this.mGlowAlphaStart, Math.min((float)(velocity * 6) * 1.0E-5f, 1.0f));
        this.mTargetDisplacement = 0.5f;
    }

    public int getColor() {
        return this.mGlowColor;
    }

    public void setColor(int color) {
        this.mGlowColor = color;
    }

    public boolean draw(Canvas canvas) {
        this.update();
        this.onDraw(canvas);
        boolean oneLastFrame = false;
        if (this.mState == 3 && this.mGlowScaleY == 0.0f) {
            this.mState = 0;
            oneLastFrame = true;
        }
        return this.mState != 0 || oneLastFrame;
    }

    public abstract void onDraw(Canvas var1);

    protected Rect getBounds() {
        return this.mBounds;
    }

    protected float getGlowAlpha() {
        return this.mGlowAlpha;
    }

    protected float getDisplacement() {
        return this.mDisplacement;
    }

    protected float getGlowScaleY() {
        return this.mGlowScaleY;
    }

    public int getMaxHeight() {
        return (int)((float)this.mBounds.height() * 2.0f + 0.5f);
    }

    private void update() {
        long time = AnimationUtils.currentAnimationTimeMillis();
        float t = Math.min((float)(time - this.mStartTime) / this.mDuration, 1.0f);
        float interp = this.mInterpolator.getInterpolation(t);
        this.mGlowAlpha = this.mGlowAlphaStart + (this.mGlowAlphaFinish - this.mGlowAlphaStart) * interp;
        this.mGlowScaleY = this.mGlowScaleYStart + (this.mGlowScaleYFinish - this.mGlowScaleYStart) * interp;
        this.mDisplacement = (this.mDisplacement + this.mTargetDisplacement) / 2.0f;
        if (t >= 0.999f) {
            switch (this.mState) {
                case 2: {
                    this.mState = 3;
                    this.mStartTime = AnimationUtils.currentAnimationTimeMillis();
                    this.mDuration = 600.0f;
                    this.mGlowAlphaStart = this.mGlowAlpha;
                    this.mGlowScaleYStart = this.mGlowScaleY;
                    this.mGlowAlphaFinish = 0.0f;
                    this.mGlowScaleYFinish = 0.0f;
                    break;
                }
                case 1: {
                    this.mState = 4;
                    this.mStartTime = AnimationUtils.currentAnimationTimeMillis();
                    this.mDuration = 2000.0f;
                    this.mGlowAlphaStart = this.mGlowAlpha;
                    this.mGlowScaleYStart = this.mGlowScaleY;
                    this.mGlowAlphaFinish = 0.0f;
                    this.mGlowScaleYFinish = 0.0f;
                    break;
                }
                case 4: {
                    this.mState = 3;
                    break;
                }
                case 3: {
                    this.mState = 0;
                }
            }
        }
    }
}

