/*
 * Decompiled with CFR 0.152.
 */
package me.chenhe.wearvision.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.View;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.chenhe.wearvision.util.UtilKt;
import me.chenhe.wearvision.widget.ClassicEdgeEffect;
import me.chenhe.wearvision.widget.CrescentEdgeEffect;
import me.chenhe.wearvision.widget.EdgeEffect;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0010\u0015\n\u0002\b\t\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007H\u0002J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J(\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0013H\u0016J@\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020 H\u0016J(\u0010!\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010#\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u0007H\u0016J\u0018\u0010$\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\u0007H\u0016J\u0010\u0010%\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u0007H\u0002J\b\u0010&\u001a\u00020\rH\u0002J\u0010\u0010'\u001a\u00020\r2\u0006\u0010(\u001a\u00020\u0013H\u0002R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lme/chenhe/wearvision/widget/VisionCoordinatorLayout;", "Landroidx/coordinatorlayout/widget/CoordinatorLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "mEdgeGlowBottom", "Lme/chenhe/wearvision/widget/EdgeEffect;", "mEdgeGlowTop", "absorbEdgeEffects", "", "velY", "draw", "canvas", "Landroid/graphics/Canvas;", "onNestedFling", "", "target", "Landroid/view/View;", "velocityX", "", "velocityY", "consumed", "onNestedScroll", "dxConsumed", "dyConsumed", "dxUnconsumed", "dyUnconsumed", "type", "", "onStartNestedScroll", "child", "axes", "onStopNestedScroll", "pullEdgeEffects", "releaseEdgeEffects", "updateSystemShape", "systemIsRound", "wearvision_release"})
public final class VisionCoordinatorLayout
extends CoordinatorLayout {
    @Nullable
    private EdgeEffect mEdgeGlowTop;
    @Nullable
    private EdgeEffect mEdgeGlowBottom;

    @JvmOverloads
    public VisionCoordinatorLayout(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        if (!this.isInEditMode()) {
            this.updateSystemShape(UtilKt.isScreenRound(context));
        }
        this.setWillNotDraw(false);
    }

    public /* synthetic */ VisionCoordinatorLayout(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    private final void updateSystemShape(boolean systemIsRound) {
        if (systemIsRound) {
            if (this.mEdgeGlowTop == null || !(this.mEdgeGlowTop instanceof CrescentEdgeEffect)) {
                this.mEdgeGlowTop = new CrescentEdgeEffect(this.getContext());
                this.mEdgeGlowBottom = new CrescentEdgeEffect(this.getContext());
            }
        } else if (this.mEdgeGlowTop == null || !(this.mEdgeGlowTop instanceof ClassicEdgeEffect)) {
            this.mEdgeGlowTop = new ClassicEdgeEffect(this.getContext());
            this.mEdgeGlowBottom = new ClassicEdgeEffect(this.getContext());
        }
    }

    public void draw(@NotNull Canvas canvas) {
        int n;
        int width;
        int restoreCount;
        boolean bl;
        boolean bl2;
        EdgeEffect edgeEffect;
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        super.draw(canvas);
        EdgeEffect edgeEffect2 = this.mEdgeGlowTop;
        if (edgeEffect2 != null) {
            edgeEffect = edgeEffect2;
            bl2 = false;
            bl = false;
            EdgeEffect top = edgeEffect;
            boolean bl3 = false;
            if (!top.isFinished()) {
                restoreCount = canvas.save();
                width = this.getWidth();
                int n2 = 0;
                int n3 = this.getScrollY();
                n = 0;
                int edgeY = Math.min(n2, n3);
                canvas.translate(0.0f, (float)edgeY);
                top.setSize(width, this.getHeight());
                if (top.draw(canvas)) {
                    this.postInvalidateOnAnimation(0, 0, this.getWidth(), top.getMaxHeight() + this.getPaddingTop());
                }
                canvas.restoreToCount(restoreCount);
            }
        }
        edgeEffect2 = this.mEdgeGlowBottom;
        if (edgeEffect2 != null) {
            edgeEffect = edgeEffect2;
            bl2 = false;
            bl = false;
            EdgeEffect bottom = edgeEffect;
            boolean bl4 = false;
            if (!bottom.isFinished()) {
                restoreCount = canvas.save();
                width = this.getWidth();
                int height = this.getHeight();
                int edgeX = -width;
                n = this.getScrollY() + height;
                boolean bl5 = false;
                int edgeY = Math.max(height, n);
                canvas.translate((float)edgeX, (float)edgeY);
                canvas.rotate(180.0f, (float)width, 0.0f);
                bottom.setSize(width, height);
                if (bottom.draw(canvas)) {
                    this.postInvalidateOnAnimation(0, this.getHeight() - this.getPaddingBottom() - bottom.getMaxHeight(), this.getWidth(), this.getHeight());
                }
                canvas.restoreToCount(restoreCount);
            }
        }
    }

    public boolean onStartNestedScroll(@NotNull View child, @NotNull View target, int axes, int type) {
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        super.onStartNestedScroll(child, target, axes, type);
        return true;
    }

    public void onNestedScroll(@NotNull View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed, int type, @NotNull int[] consumed) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)consumed, (String)"consumed");
        super.onNestedScroll(target, dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed, type, consumed);
        this.pullEdgeEffects(dyUnconsumed);
    }

    public boolean onNestedFling(@NotNull View target, float velocityX, float velocityY, boolean consumed) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (!consumed) {
            this.absorbEdgeEffects((int)velocityY);
        }
        return true;
    }

    public void onStopNestedScroll(@NotNull View target, int type) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        super.onStopNestedScroll(target, type);
        if (type == 0) {
            this.releaseEdgeEffects();
        }
    }

    private final void pullEdgeEffects(int dyUnconsumed) {
        EdgeEffect edgeEffect;
        int maxPullEffectDistance = this.getHeight() / 2;
        if (dyUnconsumed < 0) {
            EdgeEffect edgeEffect2 = this.mEdgeGlowTop;
            if (edgeEffect2 != null) {
                EdgeEffect edgeEffect3 = edgeEffect2;
                boolean bl = false;
                boolean bl2 = false;
                EdgeEffect top = edgeEffect3;
                boolean bl3 = false;
                top.onPull(-((float)dyUnconsumed) / (float)maxPullEffectDistance);
                EdgeEffect edgeEffect4 = this.mEdgeGlowBottom;
                if ((edgeEffect4 == null ? false : !edgeEffect4.isFinished()) && (edgeEffect4 = this.mEdgeGlowBottom) != null) {
                    edgeEffect4.onRelease();
                }
                this.invalidate();
            }
        } else if (dyUnconsumed > 0 && (edgeEffect = this.mEdgeGlowBottom) != null) {
            EdgeEffect edgeEffect5 = edgeEffect;
            boolean bl = false;
            boolean bl4 = false;
            EdgeEffect bottom = edgeEffect5;
            boolean bl5 = false;
            bottom.onPull((float)dyUnconsumed / (float)maxPullEffectDistance);
            EdgeEffect edgeEffect6 = this.mEdgeGlowTop;
            if ((edgeEffect6 == null ? false : !edgeEffect6.isFinished()) && (edgeEffect6 = this.mEdgeGlowTop) != null) {
                edgeEffect6.onRelease();
            }
            this.invalidate();
        }
    }

    private final void absorbEdgeEffects(int velY) {
        EdgeEffect edgeEffect;
        if (velY > 0) {
            EdgeEffect edgeEffect2 = this.mEdgeGlowBottom;
            if (edgeEffect2 != null) {
                edgeEffect2.onAbsorb(velY);
            }
        } else if (velY < 0 && (edgeEffect = this.mEdgeGlowTop) != null) {
            edgeEffect.onAbsorb(velY);
        }
    }

    private final void releaseEdgeEffects() {
        EdgeEffect edgeEffect = this.mEdgeGlowTop;
        if (edgeEffect != null) {
            edgeEffect.onRelease();
        }
        edgeEffect = this.mEdgeGlowBottom;
        if (edgeEffect != null) {
            edgeEffect.onRelease();
        }
    }

    @JvmOverloads
    public VisionCoordinatorLayout(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public VisionCoordinatorLayout(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }
}

