/*
 * Decompiled with CFR 0.152.
 */
package me.chongchong.norway;

import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import me.chongchong.norway.annotation.BuildField;
import me.chongchong.norway.annotation.Builder;
import me.chongchong.norway.bean.BuildFieldBean;
import me.chongchong.norway.bean.BuilderBean;
import me.chongchong.norway.internal.bean.BuildFieldDescriptor;
import me.chongchong.norway.internal.bean.BuilderDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.SmartLifecycle;
import org.springframework.context.support.ApplicationObjectSupport;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.core.type.ClassMetadata;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class NorwayBuildService
extends ApplicationObjectSupport
implements ResourceLoaderAware,
SmartLifecycle {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private ResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
    private MetadataReaderFactory metadataReaderFactory = new CachingMetadataReaderFactory((ResourceLoader)this.resourcePatternResolver);
    private Map<Class<?>, BuilderDescriptor> defaultBuilders = Maps.newHashMap();
    private Map<String, BuilderDescriptor> namedBuilders = Maps.newHashMap();
    private SetMultimap<Class<?>, BuildFieldDescriptor> fieldDescriptorMap = MultimapBuilder.hashKeys().hashSetValues().build();
    private Map<Class<?>, DataBuildSuit> beanBuildSuitMap = Maps.newHashMap();
    private boolean running = false;
    private String buildBeanPackages;

    public String getBuildBeanPackages() {
        return this.buildBeanPackages;
    }

    public void setBuildBeanPackages(String buildBeanPackages) {
        this.buildBeanPackages = buildBeanPackages;
    }

    private void addDefaultBuilderDescrptor(Class<?> clazz, BuilderDescriptor bd) {
        this.logger.info("add default BuilderDescriptor:{}", (Object)bd);
        BuilderDescriptor old = this.defaultBuilders.put(clazz, bd);
        if (old != null) {
            this.logger.warn("{} is replaced by {} for type {}", new Object[]{old, bd, clazz});
        }
    }

    private void addNamedBuilderDescrptor(String name, BuilderDescriptor bd) {
        this.logger.info("add named BuilderDescriptor:{}", (Object)bd);
        BuilderDescriptor old = this.namedBuilders.put(name, bd);
        if (old != null) {
            this.logger.warn("{} is replaced by {} for name {}", new Object[]{old, bd, name});
        }
    }

    private void addBuildFieldDescriptor(Class<?> clazz, BuildFieldDescriptor fd) {
        this.logger.info("add BuildFieldDescriptor:{}", (Object)fd);
        this.fieldDescriptorMap.put(clazz, (Object)fd);
    }

    public <T> void build(Collection<? extends T> beans, Class<T> clazz, int flags) {
        try {
            DataBuildSuit suit = this.beanBuildSuitMap.get(clazz);
            if (suit == null) {
                return;
            }
            suit.buildBeans(beans, flags);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public <T, V extends T> void build(V bean, Class<T> clazz, int flags) {
        this.build((V)Arrays.asList(bean), clazz, flags);
    }

    public <V> void build(V bean, int flags) {
        this.build((V)Arrays.asList(bean), (Class)bean.getClass(), flags);
    }

    public <T> List<T> getBuildedList(List<Object> ids, Class<T> clazz, int flags) {
        BuilderDescriptor bd = this.defaultBuilders.get(clazz);
        if (bd == null) {
            throw new IllegalArgumentException(clazz + " canot build.");
        }
        Map<Object, Object> objects = bd.getObjects(ids, flags);
        ArrayList list = Lists.newArrayList();
        for (Object id : ids) {
            list.add(objects.get(id));
        }
        return list;
    }

    public <T> List<T> getBuildedList(List<Object> ids, String builder, int flags) {
        BuilderDescriptor bd = this.namedBuilders.get(builder);
        if (bd == null) {
            throw new IllegalArgumentException(builder + " is not a builder name.");
        }
        Map<Object, Object> objects = bd.getObjects(ids, flags);
        ArrayList list = Lists.newArrayList();
        for (Object id : ids) {
            list.add(objects.get(id));
        }
        return list;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourcePatternResolver = ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)resourceLoader);
        this.metadataReaderFactory = new CachingMetadataReaderFactory(resourceLoader);
    }

    protected String resolveBasePackage(String basePackage) {
        return ClassUtils.convertClassNameToResourcePath((String)this.getApplicationContext().getEnvironment().resolveRequiredPlaceholders(basePackage));
    }

    public void start() {
        this.running = true;
        this.scanBuildBeanPackages();
        this.scanBuilder();
        this.createBuildSuits();
    }

    private void createBuildSuits() {
        for (Map.Entry entry : this.fieldDescriptorMap.asMap().entrySet()) {
            SetMultimap builder2FieldsMap = MultimapBuilder.hashKeys().hashSetValues().build();
            for (BuildFieldDescriptor fieldDescriptor : (Collection)entry.getValue()) {
                BuilderDescriptor builderDescriptor = null;
                if (StringUtils.hasText((String)fieldDescriptor.getBuilderName())) {
                    builderDescriptor = this.namedBuilders.get(fieldDescriptor.getBuilderName());
                } else {
                    Class<Object> type;
                    block7: {
                        try {
                            Field field = ((Class)entry.getKey()).getDeclaredField(fieldDescriptor.getPropertyName());
                            type = field.getType();
                            if (!Collection.class.isAssignableFrom(type)) break block7;
                            Type gt = field.getGenericType();
                            type = gt != null ? (Class<Object>)((ParameterizedType)gt).getActualTypeArguments()[0] : fieldDescriptor.getType();
                        }
                        catch (Exception e) {
                            this.logger.error(e.getMessage(), (Throwable)e);
                            continue;
                        }
                    }
                    builderDescriptor = this.defaultBuilders.get(type);
                }
                if (builderDescriptor == null) {
                    this.logger.warn("{} cannot be build.", (Object)fieldDescriptor);
                    continue;
                }
                builder2FieldsMap.put((Object)builderDescriptor, (Object)fieldDescriptor);
            }
            this.beanBuildSuitMap.put((Class<?>)entry.getKey(), new DefaultDataBuildSuit((Class)entry.getKey(), (SetMultimap<BuilderDescriptor, BuildFieldDescriptor>)builder2FieldsMap));
        }
    }

    private void scanBuildBeanPackages() {
        if (this.buildBeanPackages == null) {
            return;
        }
        for (String viewModelPackage : Splitter.on((String)",").omitEmptyStrings().trimResults().splitToList((CharSequence)this.buildBeanPackages)) {
            String packageSearchPath = "classpath*:" + this.resolveBasePackage(viewModelPackage) + "/" + "**/*.class";
            try {
                Resource[] resources;
                for (Resource resource : resources = this.resourcePatternResolver.getResources(packageSearchPath)) {
                    MetadataReader metadataReader;
                    ClassMetadata cm;
                    if (!resource.isReadable() || (cm = (metadataReader = this.metadataReaderFactory.getMetadataReader(resource)).getClassMetadata()).isAbstract() || cm.isInterface() || !cm.isIndependent()) continue;
                    Class clazz = ClassUtils.forName((String)cm.getClassName(), (ClassLoader)ClassUtils.getDefaultClassLoader());
                    for (PropertyDescriptor pd : BeanUtils.getPropertyDescriptors((Class)clazz)) {
                        BuildField bo;
                        if (pd.getWriteMethod() == null) continue;
                        Field field = null;
                        try {
                            field = clazz.getDeclaredField(pd.getName());
                        }
                        catch (NoSuchFieldException noSuchFieldException) {
                        }
                        catch (Exception e) {
                            this.logger.warn(e.getMessage(), (Throwable)e);
                        }
                        if (field == null || (bo = field.getAnnotation(BuildField.class)) == null) continue;
                        this.fieldDescriptorMap.put((Object)clazz, (Object)new BuildFieldDescriptor(clazz, pd.getName(), bo.flag(), bo.buildFlag(), bo.idProperty(), bo.type().equals(Void.TYPE) ? null : bo.type(), bo.buildMethod()));
                    }
                }
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private boolean checkBuilderSignature(Method m) {
        Class<?> returnType = m.getReturnType();
        Class<?>[] parameterTypes = m.getParameterTypes();
        if (returnType == null || !Map.class.isAssignableFrom(returnType)) {
            return false;
        }
        if (parameterTypes.length == 1) {
            return Collection.class.isAssignableFrom(parameterTypes[0]);
        }
        if (parameterTypes.length == 2) {
            return Collection.class.isAssignableFrom(parameterTypes[0]) && Integer.TYPE.equals(parameterTypes[1]);
        }
        return false;
    }

    private void scanBuilder() {
        String[] beanNames;
        for (String beanName : beanNames = this.getApplicationContext().getBeanDefinitionNames()) {
            Object bean = this.getApplicationContext().getBean(beanName);
            Class serviceClass = ClassUtils.getUserClass((Object)bean);
            if (BuilderBean.class.isAssignableFrom(serviceClass)) {
                BuilderBean bb = (BuilderBean)bean;
                try {
                    Class serviceClass2 = ClassUtils.getUserClass((Object)bb.getBean());
                    for (Method m : serviceClass2.getMethods()) {
                        if (!m.getName().equals(bb.getMethod())) continue;
                        if (!this.checkBuilderSignature(m)) {
                            this.logger.warn("build method signature incorrect:" + m.toString());
                            continue;
                        }
                        Class valueType = null;
                        if (StringUtils.hasText((String)bb.getForType())) {
                            valueType = ClassUtils.forName((String)bb.getForType(), (ClassLoader)ClassUtils.getDefaultClassLoader());
                        }
                        if (valueType == null) {
                            if (m.getGenericReturnType() != null) {
                                Type[] keyValueTypes = ((ParameterizedType)m.getGenericReturnType()).getActualTypeArguments();
                                valueType = (Class)keyValueTypes[1];
                            } else {
                                this.logger.warn("forType incorrect:{}", (Object)bb);
                                continue;
                            }
                        }
                        BuilderDescriptor db = new BuilderDescriptor(bb.getName(), bean, m, valueType, bb.isDefaultBuilder());
                        if (bb.isDefaultBuilder()) {
                            this.addDefaultBuilderDescrptor(valueType, db);
                        }
                        if (!StringUtils.hasText((String)bb.getName())) continue;
                        this.addNamedBuilderDescrptor(bb.getName(), db);
                    }
                    continue;
                }
                catch (Throwable t) {
                    throw Throwables.propagate((Throwable)t);
                }
            }
            if (BuildFieldBean.class.isAssignableFrom(serviceClass)) {
                BuildFieldBean bfb = (BuildFieldBean)bean;
                try {
                    Class c = ClassUtils.forName((String)bfb.getClazz(), (ClassLoader)ClassUtils.getDefaultClassLoader());
                    Class typeClass = null;
                    if (StringUtils.hasText((String)bfb.getType())) {
                        typeClass = ClassUtils.forName((String)bfb.getType(), (ClassLoader)ClassUtils.getDefaultClassLoader());
                    }
                    this.addBuildFieldDescriptor(c, new BuildFieldDescriptor(c, bfb.getProperty(), bfb.getFlag(), bfb.getBuildFlag(), bfb.getIdProperty(), typeClass, bfb.getBuilder()));
                    continue;
                }
                catch (Throwable t) {
                    throw Throwables.propagate((Throwable)t);
                }
            }
            for (Method m : serviceClass.getMethods()) {
                Builder bm = m.getAnnotation(Builder.class);
                if (bm == null) continue;
                if (!this.checkBuilderSignature(m)) {
                    this.logger.warn("build method signature incorrect:" + m.toString());
                    continue;
                }
                try {
                    Class valueType = bm.forType();
                    if (Void.TYPE.equals(valueType)) {
                        if (m.getGenericReturnType() != null && m.getGenericReturnType() instanceof ParameterizedType) {
                            Type[] keyValueTypes = ((ParameterizedType)m.getGenericReturnType()).getActualTypeArguments();
                            valueType = keyValueTypes[1] instanceof ParameterizedType ? (Class)((ParameterizedType)keyValueTypes[1]).getRawType() : (Class)keyValueTypes[1];
                        } else {
                            this.logger.warn("BuildMethod.forType() incorrect:" + m.toString());
                            continue;
                        }
                    }
                    BuilderDescriptor db = new BuilderDescriptor(bm.name(), bean, m, valueType, bm.auto());
                    if (bm.auto()) {
                        this.addDefaultBuilderDescrptor(valueType, db);
                        continue;
                    }
                    this.addNamedBuilderDescrptor(bm.name(), db);
                }
                catch (Exception e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
        }
    }

    public void stop() {
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    public int getPhase() {
        return 0;
    }

    public boolean isAutoStartup() {
        return true;
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    static class DefaultDataBuildSuit
    implements DataBuildSuit {
        private Class<?> beanClass;
        private SetMultimap<BuilderDescriptor, BuildFieldDescriptor> builder2FieldsMap;

        public DefaultDataBuildSuit(Class<?> beanClass, SetMultimap<BuilderDescriptor, BuildFieldDescriptor> builder2FieldsMap) {
            this.beanClass = beanClass;
            this.builder2FieldsMap = builder2FieldsMap;
        }

        @Override
        public void buildBeans(Collection<?> beans, int flags) {
            for (Map.Entry entry : this.builder2FieldsMap.asMap().entrySet()) {
                HashSet<Object> ids = new HashSet<Object>();
                BuildFieldDescriptor[] fields = ((Collection)entry.getValue()).toArray(new BuildFieldDescriptor[0]);
                List[] keyList = new List[fields.length];
                int buildFlag = 0;
                for (int i = 0; i < fields.length; ++i) {
                    keyList[i] = new ArrayList();
                    for (Object bean : beans) {
                        Object id = fields[i].getIdObject(bean);
                        if (id instanceof Collection) {
                            ids.addAll((Collection)id);
                        } else if (id != null) {
                            ids.add(id);
                        }
                        keyList[i].add(id);
                    }
                    buildFlag |= fields[i].getBuildFlag();
                }
                if (ids.isEmpty()) continue;
                Map<Object, Object> result = ((BuilderDescriptor)entry.getKey()).getObjects(ids, buildFlag);
                Object[] beanArray = beans.toArray();
                for (int i = 0; i < fields.length; ++i) {
                    for (int j = 0; j < beanArray.length; ++j) {
                        Object key = keyList[i].get(j);
                        if (key instanceof Collection) {
                            try {
                                Collection collection = (Collection)BeanUtils.instantiate(key.getClass());
                                for (Object id : (Collection)key) {
                                    collection.add(result.get(id));
                                }
                                fields[i].setObject(beanArray[j], collection);
                            }
                            catch (Exception exception) {}
                            continue;
                        }
                        fields[i].setObject(beanArray[j], result.get(key));
                    }
                }
            }
        }
    }

    static interface DataBuildSuit {
        public void buildBeans(Collection<?> var1, int var2);
    }
}

