/*
 * Decompiled with CFR 0.152.
 */
package me.codeboy.android.aligntextview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.view.View;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.List;
import me.codeboy.android.aligntextview.R;

public class AlignTextView
extends TextView {
    private float textHeight;
    private float textLineSpaceExtra = 0.0f;
    private int width;
    private List<String> lines = new ArrayList<String>();
    private List<Integer> tailLines = new ArrayList<Integer>();
    private Align align = Align.ALIGN_LEFT;
    private boolean firstCalc = true;
    private float lineSpacingMultiplier = 1.0f;
    private float lineSpacingAdd = 0.0f;
    private int originalHeight = 0;
    private int originalLineCount = 0;
    private int originalPaddingBottom = 0;
    private boolean setPaddingFromMe = false;

    public AlignTextView(Context context) {
        super(context);
        this.setTextIsSelectable(false);
    }

    public AlignTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setTextIsSelectable(false);
        int[] attributes = new int[]{16843287, 16843288};
        TypedArray arr = context.obtainStyledAttributes(attrs, attributes);
        this.lineSpacingAdd = arr.getDimensionPixelSize(0, 0);
        this.lineSpacingMultiplier = arr.getFloat(1, 1.0f);
        this.originalPaddingBottom = this.getPaddingBottom();
        arr.recycle();
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.AlignTextView);
        int alignStyle = ta.getInt(R.styleable.AlignTextView_align, 0);
        switch (alignStyle) {
            case 1: {
                this.align = Align.ALIGN_CENTER;
                break;
            }
            case 2: {
                this.align = Align.ALIGN_RIGHT;
                break;
            }
            default: {
                this.align = Align.ALIGN_LEFT;
            }
        }
        ta.recycle();
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (this.firstCalc) {
            String[] items;
            this.width = this.getMeasuredWidth();
            String text = this.getText().toString();
            TextPaint paint = this.getPaint();
            this.lines.clear();
            this.tailLines.clear();
            for (String item : items = text.split("\\n")) {
                this.calc((Paint)paint, item);
            }
            this.measureTextViewHeight(text, paint.getTextSize(), this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight());
            this.textHeight = 1.0f * (float)this.originalHeight / (float)this.originalLineCount;
            this.textLineSpaceExtra = this.textHeight * (this.lineSpacingMultiplier - 1.0f) + this.lineSpacingAdd;
            int heightGap = (int)((this.textLineSpaceExtra + this.textHeight) * (float)(this.lines.size() - this.originalLineCount));
            this.setPaddingFromMe = true;
            this.setPadding(this.getPaddingLeft(), this.getPaddingTop(), this.getPaddingRight(), this.originalPaddingBottom + heightGap);
            this.firstCalc = false;
        }
    }

    protected void onDraw(Canvas canvas) {
        TextPaint paint = this.getPaint();
        paint.setColor(this.getCurrentTextColor());
        paint.drawableState = this.getDrawableState();
        this.width = this.getMeasuredWidth();
        Paint.FontMetrics fm = paint.getFontMetrics();
        float firstHeight = this.getTextSize() - (fm.bottom - fm.descent + fm.ascent - fm.top);
        int gravity = this.getGravity();
        if ((gravity & 0x1000) == 0) {
            firstHeight += (this.textHeight - firstHeight) / 2.0f;
        }
        int paddingTop = this.getPaddingTop();
        int paddingLeft = this.getPaddingLeft();
        int paddingRight = this.getPaddingRight();
        this.width = this.width - paddingLeft - paddingRight;
        for (int i = 0; i < this.lines.size(); ++i) {
            float drawY = (float)i * this.textHeight + firstHeight;
            String line = this.lines.get(i);
            float drawSpacingX = paddingLeft;
            float gap = (float)this.width - paint.measureText(line);
            float interval = gap / (float)(line.length() - 1);
            if (this.tailLines.contains(i)) {
                interval = 0.0f;
                if (this.align == Align.ALIGN_CENTER) {
                    drawSpacingX += gap / 2.0f;
                } else if (this.align == Align.ALIGN_RIGHT) {
                    drawSpacingX += gap;
                }
            }
            for (int j = 0; j < line.length(); ++j) {
                float drawX = paint.measureText(line.substring(0, j)) + interval * (float)j;
                canvas.drawText(line.substring(j, j + 1), drawX + drawSpacingX, drawY + (float)paddingTop + this.textLineSpaceExtra * (float)i, (Paint)paint);
            }
        }
    }

    public void setAlign(Align align) {
        this.align = align;
        this.invalidate();
    }

    private void calc(Paint paint, String text) {
        if (text.length() == 0) {
            this.lines.add("\n");
            return;
        }
        int startPosition = 0;
        float oneChineseWidth = paint.measureText("\u4e2d");
        int ignoreCalcLength = (int)((float)this.width / oneChineseWidth);
        StringBuilder sb = new StringBuilder(text.substring(0, Math.min(ignoreCalcLength + 1, text.length())));
        for (int i = ignoreCalcLength + 1; i < text.length(); ++i) {
            if (paint.measureText(text.substring(startPosition, i + 1)) > (float)this.width) {
                startPosition = i;
                this.lines.add(sb.toString());
                sb = new StringBuilder();
                if (text.length() - startPosition <= ignoreCalcLength) {
                    this.lines.add(text.substring(startPosition));
                    break;
                }
                sb.append(text.substring(startPosition, startPosition + ignoreCalcLength));
                i = i + ignoreCalcLength - 1;
                continue;
            }
            sb.append(text.charAt(i));
        }
        if (sb.length() > 0) {
            this.lines.add(sb.toString());
        }
        this.tailLines.add(this.lines.size() - 1);
    }

    public void setText(CharSequence text, TextView.BufferType type) {
        this.firstCalc = true;
        super.setText(text, type);
    }

    public void setPadding(int left, int top, int right, int bottom) {
        if (!this.setPaddingFromMe) {
            this.originalPaddingBottom = bottom;
        }
        this.setPaddingFromMe = false;
        super.setPadding(left, top, right, bottom);
    }

    private void measureTextViewHeight(String text, float textSize, int deviceWidth) {
        TextView textView = new TextView(this.getContext());
        textView.setText((CharSequence)text);
        textView.setTextSize(0, textSize);
        int widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)deviceWidth, (int)0x40000000);
        int heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        textView.measure(widthMeasureSpec, heightMeasureSpec);
        this.originalLineCount = textView.getLineCount();
        this.originalHeight = textView.getMeasuredHeight();
    }

    public static enum Align {
        ALIGN_LEFT,
        ALIGN_CENTER,
        ALIGN_RIGHT;

    }
}

