/*
 * Decompiled with CFR 0.152.
 */
package me.codeboy.common.base.io;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class CBImage {
    private BufferedImage image;
    private int width;
    private int height;

    public CBImage(BufferedImage bufferedImage) {
        this.image = bufferedImage;
    }

    public CBImage(File file) {
        try {
            this.image = ImageIO.read(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public BufferedImage drawText(String text, int fontSize, Color color) {
        Graphics g = this.image.getGraphics();
        g.setColor(color);
        Font f = new Font("\u5b8b\u4f53", 1, fontSize);
        g.setFont(f);
        int len = text.length();
        g.drawString(text, (this.width - fontSize * len) / 2, (this.height + (int)((double)fontSize / 1.5)) / 2);
        g.dispose();
        return this.image;
    }

    public BufferedImage scale(double scaleW, double scaleH) {
        this.width = (int)((double)this.width * scaleW);
        this.height = (int)((double)this.height * scaleH);
        BufferedImage newImage = new BufferedImage(this.width, this.height, this.image.getType());
        Graphics g = newImage.getGraphics();
        g.drawImage(this.image, 0, 0, this.width, this.height, null);
        g.dispose();
        this.image = newImage;
        return this.image;
    }

    public BufferedImage rotate() {
        BufferedImage dest = new BufferedImage(this.height, this.width, 2);
        for (int i = 0; i < this.width; ++i) {
            for (int j = 0; j < this.height; ++j) {
                dest.setRGB(this.height - j - 1, i, this.image.getRGB(i, j));
            }
        }
        this.image = dest;
        return this.image;
    }

    public void save(File file) {
        try {
            ImageIO.write((RenderedImage)this.image, "png", file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public BufferedImage getImage() {
        return this.image;
    }
}

