/*
 * Decompiled with CFR 0.152.
 */
package me.codeboy.common.base.io.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.Arrays;
import java.util.List;

public class CBFileUtil {
    private static final String DEFAULT_CHARSET = "UTF-8";

    public static String getProjectPath() {
        return new File("").getAbsolutePath();
    }

    public static String getFileContent(String filePath) throws IOException {
        return CBFileUtil.getFileContent(filePath, DEFAULT_CHARSET);
    }

    public static String getFileContent(String filePath, String encoding) throws IOException {
        BufferedReader buff = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filePath), encoding));
        String content = CBFileUtil.getContent(buff);
        buff.close();
        return content;
    }

    public static List<String> getFileContentAsList(String filePath) throws IOException {
        return Arrays.asList(CBFileUtil.getFileContent(filePath).split("\\n"));
    }

    public static List<String> getFileContentAsList(File file) throws IOException {
        return CBFileUtil.getFileContentAsList(file, DEFAULT_CHARSET);
    }

    public static List<String> getFileContentAsList(String filePath, String encoding) throws IOException {
        return Arrays.asList(CBFileUtil.getFileContent(filePath, encoding).split("\\n"));
    }

    public static List<String> getFileContentAsList(File file, String encoding) throws IOException {
        return Arrays.asList(CBFileUtil.getFileContent(new FileInputStream(file), encoding).split("\\n"));
    }

    public static String getFileContent(File file) throws IOException {
        return CBFileUtil.getFileContent(new FileInputStream(file));
    }

    public static String getFileContent(InputStream is) throws IOException {
        BufferedReader buff = new BufferedReader(new InputStreamReader(is, DEFAULT_CHARSET));
        String content = CBFileUtil.getContent(buff);
        buff.close();
        return content;
    }

    public static String getFileContent(InputStream is, String encoding) throws IOException {
        BufferedReader buff = new BufferedReader(new InputStreamReader(is, encoding));
        String content = CBFileUtil.getContent(buff);
        buff.close();
        return content;
    }

    public static byte[] getFileByteContent(File file) throws IOException {
        return CBFileUtil.getFileByteContent(new FileInputStream(file), DEFAULT_CHARSET);
    }

    public static byte[] getFileByteContent(InputStream is) throws IOException {
        return CBFileUtil.getFileByteContent(is, DEFAULT_CHARSET);
    }

    public static byte[] getFileByteContent(InputStream is, String encoding) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        while ((len = is.read(buffer)) != -1) {
            outputStream.write(buffer, 0, len);
        }
        outputStream.close();
        is.close();
        return outputStream.toByteArray();
    }

    private static String getContent(BufferedReader buff) throws IOException {
        String line;
        StringBuffer content = new StringBuffer();
        while ((line = buff.readLine()) != null) {
            content.append('\n');
            content.append(line);
        }
        if (content.length() > 0) {
            return content.substring(1);
        }
        return "";
    }

    public static void saveContentToFile(String content, String filePath) throws IOException {
        CBFileUtil.saveContentToFile(content, filePath, DEFAULT_CHARSET);
    }

    public static void saveContentToFile(String content, String filePath, boolean append) throws IOException {
        CBFileUtil.saveContentToFile(content, new File(filePath), DEFAULT_CHARSET, append);
    }

    public static void saveContentToFile(String content, File file) throws IOException {
        CBFileUtil.saveContentToFile(content, file, DEFAULT_CHARSET, false);
    }

    public static void saveContentToFile(String content, File file, boolean append) throws IOException {
        CBFileUtil.saveContentToFile(content, file, DEFAULT_CHARSET, append);
    }

    public static void saveContentToFile(URL url, String filePath) throws IOException {
        CBFileUtil.saveContentToFile(url, new File(filePath));
    }

    public static void saveContentToFile(URL url, File file) throws IOException {
        int len;
        InputStream is = url.openStream();
        FileOutputStream fos = new FileOutputStream(file);
        byte[] b = new byte[1024];
        while ((len = is.read(b)) != -1) {
            fos.write(b, 0, len);
        }
        fos.flush();
        fos.close();
        is.close();
    }

    public static void saveContentToFile(String content, String filePath, String encoding) throws IOException {
        CBFileUtil.saveContentToFile(content, new File(filePath), encoding, false);
    }

    public static void saveContentToFile(String content, File file, String encoding, boolean append) throws IOException {
        BufferedWriter buff = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, append), encoding));
        buff.write(content);
        buff.flush();
        buff.close();
    }
}

