/*
 * Decompiled with CFR 0.152.
 */
package me.codeboy.common.base.net.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import me.codeboy.common.base.net.constant.CBDefaultConfig;
import me.codeboy.common.base.net.constant.CBMethod;
import me.codeboy.common.base.net.util.CBParam;
import me.codeboy.common.base.util.CBStringUtil;

public class CBConnection {
    private String url = null;
    private int timeout = 30000;
    private CBMethod method = CBDefaultConfig.METHOD;
    private String charset = "UTF-8";
    private boolean followRedirects = false;
    private boolean keepSession = true;
    private boolean pauseSessionForOnce = false;
    private String cookie = null;
    private String data = null;
    private boolean keepCharset = false;
    private boolean keepMethod = false;
    private Map<String, String> header = new HashMap<String, String>();

    public CBConnection connect(String url) {
        this.url = url;
        return this;
    }

    public CBConnection connect(String url, String charset) {
        this.url = url;
        this.charset = charset;
        return this;
    }

    public CBConnection keepCharset(boolean keepCharset) {
        this.keepCharset = keepCharset;
        return this;
    }

    public CBConnection charset(String charset) {
        this.charset = charset;
        return this;
    }

    public CBConnection keepMethod(boolean keepMethod) {
        this.keepMethod = keepMethod;
        return this;
    }

    public CBConnection method(CBMethod method) {
        this.method = method;
        return this;
    }

    public CBConnection cookie(String cookie) {
        this.header.put("Cookie", cookie);
        return this;
    }

    public CBConnection followRedirects(boolean followRedirect) {
        this.followRedirects = followRedirect;
        return this;
    }

    public CBConnection timeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public CBConnection host(String host) {
        this.header.put("Host", host);
        return this;
    }

    public CBConnection referrer(String referrer) {
        this.header.put("Referer", referrer);
        return this;
    }

    public CBConnection userAgent(String userAgent) {
        this.header.put("User-Agent", userAgent);
        return this;
    }

    public CBConnection addDefaultPcUserAgent() {
        this.header.put("User-Agent", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/46.0.2490.80 Safari/537.36");
        return this;
    }

    public CBConnection addDefaultMobileUserAgent() {
        this.header.put("User-Agent", "Mozilla/5.0 (Linux; Android 5.1.1; Nexus 5 Build/LMY48M) AppleWebKit/537.36 (KHTML, like Gecko)");
        return this;
    }

    public CBConnection header(Map<String, String> header) {
        if (header != null) {
            this.header = header;
        } else {
            header.clear();
        }
        return this;
    }

    public CBConnection header(String key, String value) {
        this.header.put(key, value);
        return this;
    }

    public CBConnection data(String data) {
        this.data = data;
        return this;
    }

    public CBConnection data(String ... data) {
        if (data.length % 2 == 0) {
            this.data = CBParam.paramsToString(this.charset, data);
        }
        return this;
    }

    public CBConnection data(Map<String, String> data) {
        if (data != null) {
            this.data = CBParam.paramsToString(this.charset, data);
        }
        return this;
    }

    public CBConnection keepSession(boolean keepSession) {
        this.keepSession = keepSession;
        if (!keepSession) {
            this.cookie = null;
        }
        return this;
    }

    public CBConnection doNotTakeSessionForOnce() {
        this.pauseSessionForOnce = true;
        return this;
    }

    public String execute() throws IOException {
        String line;
        if (CBStringUtil.isEmptyOrNull(this.url)) {
            return null;
        }
        StringBuilder netString = new StringBuilder();
        URL url = new URL(this.url);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod(this.method.value);
        for (Map.Entry<String, String> item : this.header.entrySet()) {
            conn.setRequestProperty(item.getKey(), item.getValue());
        }
        if (this.keepSession && !CBStringUtil.isEmptyOrNull(this.cookie) && !this.header.containsKey("Cookie") && !this.pauseSessionForOnce) {
            conn.setRequestProperty("Cookie", this.cookie);
        }
        this.pauseSessionForOnce = false;
        conn.setConnectTimeout(this.timeout);
        conn.setReadTimeout(this.timeout);
        conn.setInstanceFollowRedirects(this.followRedirects);
        if (this.method == CBMethod.POST && !CBStringUtil.isEmptyOrNull(this.data)) {
            conn.setDoOutput(true);
            OutputStream out = conn.getOutputStream();
            out.write(this.data.getBytes());
            out.flush();
            out.close();
        }
        BufferedReader buff = new BufferedReader(new InputStreamReader(conn.getInputStream(), this.charset));
        while ((line = buff.readLine()) != null) {
            netString.append("\n");
            netString.append(line);
        }
        buff.close();
        String tmpCookie = conn.getHeaderField("Set-Cookie");
        if (this.keepSession && CBStringUtil.isEmptyOrNull(this.cookie) && !CBStringUtil.isEmptyOrNull(tmpCookie)) {
            this.cookie = tmpCookie;
        }
        return netString.length() > 0 ? netString.substring(1) : netString.toString();
    }

    protected CBConnection resetSomeState() {
        this.url = null;
        this.followRedirects = false;
        this.header.clear();
        this.data = null;
        if (!this.keepMethod) {
            this.method = CBDefaultConfig.METHOD;
        }
        if (!this.keepCharset) {
            this.charset = "UTF-8";
        }
        return this;
    }

    public void saveToFile(File file) throws IOException {
        int len;
        if (CBStringUtil.isEmptyOrNull(this.url)) {
            return;
        }
        URL url = new URL(this.url);
        URLConnection conn = url.openConnection();
        InputStream is = conn.getInputStream();
        FileOutputStream os = new FileOutputStream(file);
        byte[] b = new byte[1024];
        while ((len = is.read(b)) != -1) {
            ((OutputStream)os).write(b, 0, len);
        }
        ((OutputStream)os).close();
        is.close();
    }
}

