/*
 * Decompiled with CFR 0.152.
 */
package me.codeboy.common.base.task;

import java.util.ArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import me.codeboy.common.base.task.CBTask;
import me.codeboy.common.base.task.impl.ICBTask;
import me.codeboy.common.base.task.listener.CBTaskListener;

public class CBTaskController {
    private int maxTaskNumber = 5;
    private int currentExecuteTaskNumber = 0;
    private LinkedBlockingQueue<ICBTask> queue = new LinkedBlockingQueue();
    private boolean stopSign = false;
    final Lock lock = new ReentrantLock();
    final Condition condition = this.lock.newCondition();

    public CBTaskController() {
    }

    public CBTaskController(int maxTaskNumber) {
        this.maxTaskNumber = maxTaskNumber;
    }

    public void addTask(CBTask task) {
        this.queue.offer(task);
    }

    public void startAllTasks() {
        while (this.queue.size() != 0 && !this.stopSign) {
            ICBTask task = this.queue.poll();
            if (task == null) continue;
            this.setAndStartTask(task);
        }
    }

    public void startAllTasksAndWaiting() throws InterruptedException {
        ArrayList<ICBTask> taskList = new ArrayList<ICBTask>();
        while (this.queue.size() != 0 && !this.stopSign) {
            ICBTask task = this.queue.poll();
            if (task == null) continue;
            taskList.add(task);
            this.setAndStartTask(task);
        }
        for (ICBTask task : taskList) {
            if (task.isTaskFinished()) continue;
            task.waitForEnd();
        }
    }

    private void setAndStartTask(ICBTask task) {
        task.setTaskListener(new CBTaskListener(){

            @Override
            public void onTaskStart() {
                CBTaskController.this.lock.lock();
                if (CBTaskController.this.currentExecuteTaskNumber > CBTaskController.this.maxTaskNumber) {
                    try {
                        CBTaskController.this.condition.await();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                CBTaskController.this.currentExecuteTaskNumber++;
                CBTaskController.this.lock.unlock();
            }

            @Override
            public void onTaskEnd() {
                CBTaskController.this.lock.lock();
                CBTaskController.this.currentExecuteTaskNumber--;
                CBTaskController.this.condition.signal();
                CBTaskController.this.lock.unlock();
            }
        });
        task.startTask();
    }

    public void stopAllTasks() {
        ICBTask task;
        this.stopSign = true;
        while ((task = this.queue.poll()) != null) {
            task.stopTask();
        }
    }
}

