package me.codeboy.tools.io;

/**
 * 日志
 * <p>
 * 默认的Logger采用<strong>{}</strong>为占位符
 * </p>
 */
public class CBLog {
    private static CBLogger logger = new CBDummyLogger();

    public static void debug(String msg) {
        logger.debug(msg);
    }

    public static void debug(String format, Object... arguments) {
        logger.debug(format, arguments);
    }

    public static void debug(String msg, Throwable throwable) {
        logger.debug(msg, throwable);
    }

    public static void info(String msg) {
        logger.info(msg);
    }

    public static void info(String format, Object... arguments) {
        logger.info(format, arguments);
    }

    public static void info(String msg, Throwable throwable) {
        logger.info(msg, throwable);
    }

    public static void warn(String msg) {
        logger.warn(msg);
    }

    public static void warn(String format, Object... arguments) {
        logger.warn(format, arguments);
    }

    public static void error(String msg) {
        logger.error(msg);
    }

    public static void warn(String msg, Throwable throwable) {
        logger.warn(msg, throwable);
    }

    public static void error(String format, Object... arguments) {
        logger.error(format, arguments);
    }

    public static void error(String msg, Throwable throwable) {
        logger.error(msg, throwable);
    }

    public static void setLogger(CBLogger logger) {
        CBLog.logger = logger;
    }

    public interface CBLogger {
        void debug(String msg);

        void debug(String format, Object... arguments);

        void debug(String msg, Throwable throwable);

        void info(String msg);

        void info(String format, Object... arguments);

        void info(String msg, Throwable throwable);

        void warn(String msg);

        void warn(String format, Object... arguments);

        void warn(String msg, Throwable throwable);

        void error(String msg);

        void error(String msg, Object... arguments);

        void error(String msg, Throwable throwable);
    }
}
