package me.codeboy.tools.lang;

import java.math.RoundingMode;
import java.text.DecimalFormat;

/**
 * 数字工具
 */
public class CBNum {

    /**
     * 保留几位小数，小数部分末尾的0会被保留
     *
     * @param num           数字
     * @param fractionalLen 小数长度
     * @return 格式化后的数字
     */
    public static String format(double num, int fractionalLen) {
        return format(num, fractionalLen, true);
    }

    /**
     * 保留几位小数，小数部分末尾的0会被保留
     *
     * @param num           数字
     * @param fractionalLen 小数长度
     * @param roundingMode  模式
     * @return 格式化后的数字
     */
    public static String format(double num, int fractionalLen, RoundingMode roundingMode) {
        return format(num, fractionalLen, true, roundingMode);
    }

    /**
     * 保留几位小数，舍去后面的小数，固定小数长度
     *
     * @param num           数字
     * @param fractionalLen 小数长度
     * @param fixed         固定小数长度
     * @return 格式化后的数字
     */
    public static String format(double num, int fractionalLen, boolean fixed) {
        return format(num, fractionalLen, fixed, RoundingMode.HALF_EVEN);
    }

    /**
     * 保留几位小数，固定小数长度
     *
     * @param num           数字
     * @param fractionalLen 小数长度
     * @param fixed         固定小数长度
     * @param roundingMode  模式
     * @return 格式化后的数字
     */
    public static String format(double num, int fractionalLen, boolean fixed, RoundingMode roundingMode) {
        DecimalFormat format = new DecimalFormat("0." + generatePattern(fractionalLen, fixed));
        format.setRoundingMode(roundingMode);
        return format.format(num);
    }

    /**
     * 百分比模式
     *
     * @param num 数字
     * @return 格式化后的数字
     */
    public static String percent(double num) {
        return percent(num, 2);
    }

    /**
     * 百分比模式
     *
     * @param num           数字
     * @param fractionalLen 小数长度
     * @return 格式化后的数字
     */
    public static String percent(double num, int fractionalLen) {
        return percent(num, fractionalLen, RoundingMode.HALF_EVEN);
    }

    /**
     * 百分比格式化
     *
     * @param num           数字
     * @param fractionalLen 小数长度
     * @param roundingMode  模式
     * @return 格式化后的数字
     */
    public static String percent(double num, int fractionalLen, RoundingMode roundingMode) {
        return format(num * 100, fractionalLen, true, roundingMode);
    }

    private static String generatePattern(int len, boolean fixed) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < len; i++) {
            builder.append(fixed ? "0" : "#");
        }
        return builder.toString();
    }
}
