package me.codeboy.tools.lang;

import me.codeboy.tools.annotation.CBNotNull;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringJoiner;

/**
 * 字符串工具
 */
public class CBString {
    public final static String EMPTY = "";

    /**
     * 一些列字符串是否为null或者长度为0
     *
     * @param ins 输入字符串
     * @return 是否为空或长度为0
     */
    public static boolean isEmptyOrNull(String... ins) {
        if (ins == null || ins.length == 0) {
            return true;
        }
        for (String in : ins) {
            if (in == null || in.length() == 0) {
                return true;
            }
        }
        return false;
    }

    /**
     * 将集合中的元素使用分隔符拼接
     *
     * @param collection 集合
     * @param separator  分隔符
     * @param <T>        对象，拼接时调用其<strong>toString方法</strong>
     * @return 拼接后的字符串
     */
    public static <T> String join(Collection<T> collection, @CBNotNull String separator) {
        if (collection == null) {
            return "";
        }
        StringJoiner joiner = new StringJoiner(separator);
        for (T item : collection) {
            if (item == null) {
                continue;
            }
            joiner.add(item.toString());
        }
        return joiner.toString();
    }

    /**
     * 字符串分割
     *
     * @param origin    原始字符串
     * @param separator 分隔符
     * @return 分割后的字符串
     */
    @CBNotNull
    public static List<String> split(String origin, @CBNotNull String separator) {
        List<String> items = new ArrayList<>();
        if (origin == null) {
            return items;
        }
        if (separator.length() == 0) {
            items.add(origin);
            return items;
        }
        int pos = 0;
        int index;
        while ((index = origin.indexOf(separator, pos)) != -1) {
            items.add(origin.substring(pos, index));
            pos = index + separator.length();
        }
        items.add(origin.substring(pos));
        return items;
    }

}