package me.codeboy.tools.net;

import me.codeboy.tools.io.CBLog;
import me.codeboy.tools.net.core.CBConnection;
import me.codeboy.tools.net.ssl.CBHostnameVerifier;
import me.codeboy.tools.net.ssl.CBX509TrustManager;

import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;
import java.security.GeneralSecurityException;

/**
 * http网络操作
 */
public class CBHttp extends CBConnection {

    //设置ssl证书信任
    static {
        SSLContext sslContext = null;
        try {
            sslContext = SSLContext.getInstance("SSL");
            X509TrustManager[] xtmArray = new X509TrustManager[]{new CBX509TrustManager()};
            sslContext.init(null, xtmArray, new java.security.SecureRandom());
        } catch (GeneralSecurityException e) {
            CBLog.warn("ssl error", e);
        }
        if (sslContext != null) {
            HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
        }
        HttpsURLConnection.setDefaultHostnameVerifier(new CBHostnameVerifier());
    }

    public static CBConnection instance() {
        return new CBHttp();
    }
}