package me.codeboy.tools.net.core;

import me.codeboy.tools.lang.CBString;

import java.util.UUID;

public enum CBContentType {
    FORM,
    MULTIPART_FORM,
    JSON;

    private String boundary;

    String string(String charset) {
        switch (this) {
            case FORM:
                return "application/x-www-form-urlencoded;charset=" + charset;
            case MULTIPART_FORM:
                return "multipart/form-data;boundary=" + boundary();
            case JSON:
                return "application/json;charset=" + charset;
        }
        return CBString.EMPTY;
    }

    String boundary() {
        if (boundary == null) {
            boundary = UUID.randomUUID().toString();
        }
        return boundary;
    }
}
