package me.codeboy.tools.net.core;

import me.codeboy.tools.annotation.CBNotNull;
import me.codeboy.tools.lang.CBString;
import me.codeboy.tools.net.util.CBCookieUtil;

import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

import static me.codeboy.tools.net.core.CBHeader.LOCATION;
import static me.codeboy.tools.net.core.CBHeader.SET_COOKIE;

public class CBResponse {

    private final CBConnection connection;
    private Map<String, String> headers;
    private boolean success;
    private int statusCode;
    private String msg;
    private byte[] body;
    private Charset charset;

    CBResponse(@CBNotNull CBConnection connection) {
        this.connection = connection;
    }

    @CBNotNull
    public Map<String, String> headers() {
        if (headers == null) {
            headers = new HashMap<>();
        }
        return headers;
    }

    protected void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public boolean success() {
        return success;
    }

    protected void setSuccess(boolean success) {
        this.success = success;
    }

    public int statusCode() {
        return statusCode;
    }

    /**
     * 获取网络请求返回header中location信息
     * <p>
     * 一般在状态码为302的时候，会获取该信息
     * </p>
     *
     * @return location url
     */
    public String location() {
        return headers().get(LOCATION);
    }

    /**
     * 获取网络请求返回header中cookie信息
     *
     * @return cookie
     */
    public String cookie() {
        return headers().get(SET_COOKIE);
    }

    /**
     * 获取网络请求返回header中cookie信息
     *
     * @return cookie
     */
    public Map<String, String> cookieAsMap() {
        return CBCookieUtil.parse(headers().get(SET_COOKIE));
    }

    protected void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
        this.success = statusCode >= 200 && statusCode < 400;
    }

    public byte[] body() {
        return body;
    }

    public String bodyString() {
        if (body == null) {
            return CBString.EMPTY;
        }
        return new String(body, charset);
    }

    /**
     * 指定body编码
     *
     * @param charset 编码
     * @return body字符串
     */
    public String bodyString(Charset charset) {
        if (body == null) {
            return CBString.EMPTY;
        }
        return new String(body, charset);
    }

    protected void setBody(byte[] body) {
        this.body = body;
    }

    protected void setCharset(Charset charset) {
        this.charset = charset;
    }

    public String msg() {
        return msg;
    }

    protected void setMsg(String msg) {
        this.msg = msg;
    }

    public String getCurlCommand() {
        return connection.getCurlCommand();
    }

    @Override
    public String toString() {
        return "CBResponse{" +
                "statusCode=" + statusCode +
                ", success=" + success +
                ", headers=" + headers +
                ", msg='" + msg + '\'' +
                ", body='" + bodyString() + '\'' +
                '}';
    }
}
