package me.codeboy.tools.net.util;

import me.codeboy.tools.annotation.CBNotNull;
import me.codeboy.tools.io.CBLog;
import me.codeboy.tools.lang.CBString;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CBCookieUtil {
    private static final List<String> COOKIE_PROPERTIES1 = new ArrayList<>();
    private static final List<String> COOKIE_PROPERTIES2 = new ArrayList<>();

    static {
        COOKIE_PROPERTIES1.add("Expires=");
        COOKIE_PROPERTIES1.add("Max-Age=");
        COOKIE_PROPERTIES1.add("Domain=");
        COOKIE_PROPERTIES1.add("Path=");
        COOKIE_PROPERTIES2.add("Secure");
        COOKIE_PROPERTIES2.add("HttpOnly");
        COOKIE_PROPERTIES2.add("SameSite");
    }

    @CBNotNull
    public static Map<String, String> parse(String cookieStr) {
        Map<String, String> cookies = new HashMap<>();
        if (CBString.isEmptyOrNull(cookieStr)) {
            return cookies;
        }
        String[] cookieItems = cookieStr.split(";");
        for (String singleCookie : cookieItems) {
            singleCookie = singleCookie.trim();
            boolean specialStrFlag = false;
            for (String property : COOKIE_PROPERTIES1) {
                if (singleCookie.startsWith(property)) {
                    specialStrFlag = true;
                    break;
                }
            }
            // 特殊标示，跳过
            if (specialStrFlag || COOKIE_PROPERTIES2.contains(singleCookie)) {
                continue;
            }
            int pos = singleCookie.indexOf('=');
            if (pos == -1) {
                CBLog.warn("cookie format error, [{}]", singleCookie);
                continue;
            }
            String key = singleCookie.substring(0, pos);
            String val = singleCookie.substring(pos + 1);
            cookies.put(key, val);
        }
        return cookies;
    }
}
