package me.codeboy.tools.net.util;

import me.codeboy.tools.io.CBLog;
import me.codeboy.tools.lang.CBString;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.StringJoiner;

/**
 * 参数转换
 */
public class CBParam {
    /**
     * convert parameters to string
     *
     * @param params parameter
     * @return 拼接后的字符串
     */
    public static String combine(String... params) {
        if (params.length == 0 || params.length % 2 != 0) {
            return CBString.EMPTY;
        }
        StringJoiner joiner = new StringJoiner("&");
        for (int i = 0; i < params.length - 1; i = i + 2) {
            joiner.add(params[i] + "=" + params[i + 1]);
        }
        return joiner.toString();
    }


    /**
     * convert parameters to string
     *
     * @param params parameter
     * @return 拼接后的字符串
     */
    public static String combine(Map<String, String> params) {
        if (params == null || params.size() == 0) {
            return CBString.EMPTY;
        }
        StringJoiner joiner = new StringJoiner("&");
        for (Map.Entry<String, String> item : params.entrySet()) {
            joiner.add(item.getKey() + "=" + item.getValue());
        }
        return joiner.toString();
    }

    /**
     * convert parameters to string
     *
     * @param charset 编码
     * @param params  parameter
     * @return 拼接后的字符串
     */
    public static String combine(Charset charset, String... params) {
        if (params.length == 0 || params.length % 2 != 0) {
            return CBString.EMPTY;
        }
        StringJoiner joiner = new StringJoiner("&");
        try {
            for (int i = 0; i < params.length - 1; i = i + 2) {
                joiner.add(URLEncoder.encode(params[i], charset.toString()) + "=" + URLEncoder.encode(params[i + 1], charset.toString()));
            }
        } catch (UnsupportedEncodingException e) {
            CBLog.warn("parameter encoding error", e);
        }
        return joiner.toString();
    }

    /**
     * convert parameters to string
     *
     * @param charset 编码
     * @param params  parameter
     * @return 拼接后的字符串
     */
    public static String combine(Charset charset, Map<String, String> params) {
        if (params == null || params.size() == 0) {
            return CBString.EMPTY;
        }
        StringJoiner joiner = new StringJoiner("&");
        try {
            String charsetName = charset.name();
            for (Map.Entry<String, String> item : params.entrySet()) {
                joiner.add(URLEncoder.encode(item.getKey(), charsetName) + "=" + URLEncoder.encode(item.getValue(), charsetName));
            }
        } catch (UnsupportedEncodingException e) {
            CBLog.warn("parameter encoding error", e);
        }
        return joiner.toString();
    }
}
