package me.codeboy.tools.security;

import me.codeboy.tools.util.CBHex;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

/**
 * MD5、SHA等hash加密
 *
 * @author YD
 */
public class CBHash {
    /**
     * Md5加密
     *
     * @param text 待加密的字符串
     * @return md5 编码，失败则返回null
     */
    public static String md5(String text) {
        if (text == null) {
            return null;
        }
        return md5(text.getBytes(StandardCharsets.UTF_8));
    }

    /**
     * Md5加密
     *
     * @param bytes 待加密的字节数组
     * @return md5 编码，失败则返回null
     */
    public static String md5(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        } catch (NoSuchAlgorithmException e) {
            // can't reach here
            throw new RuntimeException(e);
        }
        messageDigest.update(bytes);
        return CBHex.byte2hex(messageDigest.digest());
    }

    /**
     * sha加密
     *
     * @param text 待加密的字符串
     * @return 编码后的字符串
     */
    public static String sha(String text) {
        if (text == null) {
            return null;
        }
        return sha(text.getBytes(StandardCharsets.UTF_8));
    }

    /**
     * sha加密
     *
     * @param bytes 待加密的字符串
     * @return 编码后的字符串
     */
    public static String sha(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("SHA");
        } catch (NoSuchAlgorithmException e) {
            // can't reach here
            throw new RuntimeException(e);
        }
        messageDigest.update(bytes);
        return CBHex.byte2hex(messageDigest.digest());
    }

}