package me.codeboy.tools.task.base;

import me.codeboy.tools.annotation.CBNotNull;
import me.codeboy.tools.task.CBTaskPool;

/**
 * task listener, don't do any task which needs a lot of time
 */
public interface CBTaskListener<T> {

    /**
     * @param taskPool taskPool，可以在这里向任务池再次提交任务或取消
     *                 任务开始
     * @param task task
     */
    void onStart(@CBNotNull CBTaskPool taskPool, @CBNotNull CBTask<T> task);

    /**
     * 任务结束
     *
     * @param taskPool taskPool，可以在这里向任务池再次提交任务或取消
     * @param task task
     * @param result   结果
     */
    void onFinish(@CBNotNull CBTaskPool taskPool, @CBNotNull CBTask<T> task, T result);

    /**
     * 任务失败，可能发生异常
     *
     * @param taskPool taskPool，可以在这里向任务池再次提交任务或取消
     * @param task task
     * @param ex       异常信息
     */
    void onError(@CBNotNull CBTaskPool taskPool, @CBNotNull CBTask<T> task, Exception ex);
}
