package me.codeboy.tools.util;

import me.codeboy.tools.annotation.CBNotNull;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

/**
 * Base64 编码解码
 */
public final class CBBase64 {
    /**
     * base64编码
     *
     * @param bytes 字节数组
     * @return 编码后字符串
     */
    public static byte[] encode(@CBNotNull byte[] bytes) {
        return Base64.getEncoder().encode(bytes);
    }

    /**
     * base64编码，采用UTF-8编码集
     *
     * @param bytes 字节数组
     * @return 编码后字符串
     */
    public static String encodeToString(@CBNotNull byte[] bytes) {
        return Base64.getEncoder().encodeToString(bytes);
    }
    /**
     * base64编码，采用UTF-8编码集
     *
     * @param in 输入字符串
     * @return 编码后字符串
     */
    public static String encodeToString(@CBNotNull String in) {
        return encodeToString(in, StandardCharsets.UTF_8);
    }

    /**
     * base64编码
     *
     * @param in      输入字符串
     * @param charset 编码集
     * @return 编码后字符串
     */
    public static String encodeToString(@CBNotNull String in, Charset charset) {
        return Base64.getEncoder().encodeToString(in.getBytes(charset));
    }

    /**
     * base解码
     *
     * @param in 字符串
     * @return 解码后字符串
     */
    public static byte[] decode(@CBNotNull String in) {
        return Base64.getDecoder().decode(in);
    }

    /**
     * base解码,采用默认编码集
     *
     * @param in 字符串
     * @return 解码后字符串
     */
    public static String decodeToString(@CBNotNull String in) {
        return decodeToString(in, StandardCharsets.UTF_8);
    }

    /**
     * base解码
     *
     * @param in      输入字符串
     * @param charset 编码集
     * @return 解码后字符串
     */
    public static String decodeToString(@CBNotNull String in, Charset charset) {
        return new String(decode(in), charset);
    }
}