package me.codeboy.tools.util;

import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * 日期格式化工具
 */
public class CBDate {

    /**
     * 当前格式化的时间
     *
     * @return 时间，示例: 2020-10-01 13:24:01
     */
    public static String formatTime() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(new Date());
    }

    /**
     * 当前格式化的时间，包含毫秒
     *
     * @return 时间，示例: 2020-10-01 13:24:01.898
     */
    public static String formatTimeWithMs() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        return sdf.format(new Date());
    }

    /**
     * 格式化的时间
     *
     * @param time 时间戳
     * @return 时间，示例: 2020-10-01 13:24:01
     */
    public static String formatTime(long time) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(time);
    }

    /**
     * 当前格式化的日期
     *
     * @return 日期，示例: 2020-10-01
     */
    public static String formatDate() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(new Date());
    }
}
