package me.codeboy.tools.util;

import me.codeboy.tools.lang.CBString;

/**
 * 十六进制工具
 */
public class CBHex {
    /**
     * 字节数组转换为16进制
     *
     * @param arr 字节数组
     * @return 16进制字符串
     */
    public static String byte2hex(byte[] arr) {
        StringBuilder sb = new StringBuilder();
        for (byte b : arr) {
            sb.append(Integer.toHexString((b & 0xFF) | 0x100), 1, 3);
        }
        return sb.toString();
    }

    /**
     * 16进制转换为字节数组
     *
     * @param hex hex字符串
     * @return byte数组，如果hex长度不为偶数，返回空数组
     */
    public static byte[] hex2Byte(String hex) {
        if (CBString.isEmptyOrNull(hex) || hex.length() % 2 != 0) {
            return new byte[0];
        }
        hex = hex.toLowerCase();
        final byte[] byteArray = new byte[hex.length() >> 1];
        int index = 0;
        for (int i = 0; i < hex.length(); i = i + 2) {
            byte highDit = (byte) (Character.digit(hex.charAt(index), 16) & 0xFF);
            byte lowDit = (byte) (Character.digit(hex.charAt(index + 1), 16) & 0xFF);
            byteArray[i] = (byte) (highDit << 4 | lowDit);
        }
        return byteArray;
    }
}
