package me.codeboy.tools.util;

import java.util.*;
import java.util.Map.Entry;

/**
 * 按照键值对中 值排序 TreeMap
 *
 * @param <K> 键值对对应键
 * @param <V> 键值对对应值
 */
public class CBMap<K, V> {

    private final int GROW_ASC = 1; //升序
    private final int GROW_DESC = -1; //降序

    /**
     * 按照Map中value进行升序排列
     *
     * @param sourceMap 要排序 map
     * @return 排序后 map
     */
    public Map<K, V> sortByValueAsc(Map<K, V> sourceMap) {
        return sortByValue(sourceMap, GROW_ASC);
    }

    /**
     * 按照Map中value进行降序排列
     *
     * @param sourceMap 要排序 map
     * @return 排序后 map
     */
    public Map<K, V> sortByValueDesc(Map<K, V> sourceMap) {
        return sortByValue(sourceMap, GROW_DESC);
    }

    /**
     * 按照Map中key进行升序排列
     *
     * @param sourceMap 要排序 map
     * @return 排序后 map
     */
    public Map<K, V> sortByAsc(Map<K, V> sourceMap) {
        return sortByKey(sourceMap, GROW_ASC);
    }

    /**
     * 按照Map中key进行降序排列
     *
     * @param sourceMap 要排序 map
     * @return 排序后 map
     */
    public Map<K, V> sortByKeyDesc(Map<K, V> sourceMap) {
        return sortByKey(sourceMap, GROW_DESC);
    }

    /**
     * 根据map中key进行排序
     *
     * @param sourceMap  要排序 map
     * @param sortPolicy 排序规则，升序或者降序
     * @return 排序后 map
     */
    private Map<K, V> sortByKey(Map<K, V> sourceMap, final int sortPolicy) {
        List<Entry<K, V>> list = new ArrayList<>(sourceMap.entrySet());
        list.sort((o1, o2) -> {
            K k1 = o1.getKey();
            K k2 = o2.getKey();
            return compareValue(k1, k2) * sortPolicy;
        });

        return getKvMap(list);
    }

    /**
     * 根据map中value进行排序
     *
     * @param sourceMap  要排序 map
     * @param sortPolicy 排序规则，升序或者降序
     * @return 排序后 map
     */
    private Map<K, V> sortByValue(Map<K, V> sourceMap, final int sortPolicy) {
        List<Entry<K, V>> list = new ArrayList<>(sourceMap.entrySet());
        Collections.sort(list, (o1, o2) -> {
            V v1 = o1.getValue();
            V v2 = o2.getValue();
            return compareValue(v1, v2) * sortPolicy;
        });

        return getKvMap(list);
    }

    private Map<K, V> getKvMap(List<Entry<K, V>> list) {
        Map<K, V> desMap = new LinkedHashMap<K, V>();
        for (int i = 0; i < list.size(); i++) {
            Entry<K, V> item = list.get(i);
            desMap.put(item.getKey(), item.getValue());
        }
        return desMap;
    }

    /**
     * 对键值对中值进行比较
     * 1. 针对6种基本类型，short int long float double char
     * 2. 针对接口，Comparable
     * 3. 其他一律返回相等
     *
     * @param v1 值1
     * @param v2 值2
     * @return 比较结果
     */
    private int compareValue(Object v1, Object v2) {
        if (v1 instanceof Integer) {
            return Integer.compare((Integer) v1, (Integer) v2);
        }

        if (v1 instanceof Float) {
            return Float.compare((Float) v1, (Float) v2);
        }

        if (v1 instanceof Double) {
            return Double.compare((Double) v1, (Double) v2);
        }

        if (v1 instanceof Long) {
            return Long.compare((Long) v1, (Long) v2);
        }

        if (v1 instanceof Character) {
            return Character.compare((Character) v1, (Character) v2);
        }

        if (v1 instanceof Short) {
            return Short.compare((Short) v1, (Short) v2);
        }

        if (v1 instanceof Comparable) {
            return ((Comparable) v1).compareTo(v2);
        }

        return 0;
    }
}