package me.codeboy.tools.util;

import me.codeboy.tools.annotation.CBNotNull;

import java.util.Random;

/**
 * 随机数
 */
public class CBRandom {
    private final static String SEED_NUM = "0123456789";
    private final static String SEED_LOWERCASE = "abcdefghijklmnopqrstuvwxyz";
    private final static String SEED_UPPERCASE = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final Random sRandom = new Random();

    public static int nextInt() {
        return sRandom.nextInt();
    }

    public static int nextInt(int bound) {
        return sRandom.nextInt(bound);
    }

    public static long nextLong() {
        return sRandom.nextLong();
    }

    public static double nextDouble() {
        return sRandom.nextDouble();
    }

    public static float nextFloat() {
        return sRandom.nextFloat();
    }

    public static boolean nextBoolean() {
        return sRandom.nextBoolean();
    }

    public static double nextGaussian() {
        return sRandom.nextGaussian();
    }

    public static void newtByteArray(byte[] bytes) {
        sRandom.nextBytes(bytes);
    }

    public static String nextString(int len) {
        return nextString(StringType.NUM_LOWERCASE_UPPERCASE, len);
    }

    public static String nextString(StringType stringType, int len) {
        String baseStr;
        switch (stringType) {
            case NUM:
                baseStr = SEED_NUM;
                break;
            case LOWERCASE:
                baseStr = SEED_LOWERCASE;
                break;
            case UPPERCASE:
                baseStr = SEED_UPPERCASE;
                break;
            case NUM_LOWERCASE:
                baseStr = SEED_NUM + SEED_LOWERCASE;
                break;
            case NUM_UPPERCASE:
                baseStr = SEED_NUM + SEED_UPPERCASE;
                break;
            case LOWERCASE_UPPERCASE:
                baseStr = SEED_LOWERCASE + SEED_UPPERCASE;
                break;
            default:
                baseStr = SEED_NUM + SEED_LOWERCASE + SEED_UPPERCASE;
                break;
        }
        StringBuilder builder = new StringBuilder(len);
        for (int i = 0; i < len; i++) {
            builder.append(nextStringChar(baseStr));
        }
        return builder.toString();
    }

    private static char nextStringChar(@CBNotNull String str) {
        return str.charAt(nextInt(str.length()));
    }

    public enum StringType {
        NUM, LOWERCASE, UPPERCASE, NUM_LOWERCASE, NUM_UPPERCASE, LOWERCASE_UPPERCASE, NUM_LOWERCASE_UPPERCASE;
    }

}
