package me.codeboy.tools.util;

import me.codeboy.tools.annotation.CBNotNull;
import me.codeboy.tools.io.CBLog;

import java.io.BufferedReader;
import java.io.InputStreamReader;

/**
 * 命令行工具
 */
public class CBShell {
    /**
     * 执行系统命令，仅支持linux/unix
     *
     * @param script 脚本
     * @return 输出结果
     */
    public static String exec(@CBNotNull String script) {
        try {
            String[] cmds = new String[]{"/bin/sh", "-c", script};
            Process ps = Runtime.getRuntime().exec(cmds);
            BufferedReader br = new BufferedReader(new InputStreamReader(ps.getInputStream()));
            StringBuilder sb = new StringBuilder();
            String line;
            while ((line = br.readLine()) != null) {
                sb.append(line).append("\n");
            }
            br.close();
            ps.destroy();
            String result = sb.toString();
            if (result.length() > 0) {
                result = result.substring(0, result.length() - 1);
            }
            return result;
        } catch (Exception e) {
            CBLog.error("exec cmd failed, [" + script + "]", e);
        }
        return null;
    }
}
