package me.codeboy.tools.util;

import me.codeboy.tools.lang.CBString;

/**
 * 版本比较
 */
public class CBVersion {
    /**
     * 版本号比较(例如1.10.0与1.2.0版本比较)，返回是否有新版本
     *
     * @param oldVersion 旧版本
     * @param newVersion 新版本
     * @return 新版本返回1，旧版本返回-1，相等返回0
     */
    public static int compare(String oldVersion, String newVersion) {
        //版本号有一个不正常就返回false
        if (CBString.isEmptyOrNull(oldVersion)) {
            return 1;
        }
        if (CBString.isEmptyOrNull(newVersion)) {
            return -1;
        }

        String[] oldVersionSnippet = oldVersion.split("\\.");
        String[] newVersionSnippet = newVersion.split("\\.");
        int maxComparePosition = Math.min(oldVersionSnippet.length, newVersionSnippet.length);

        int i = 0;
        for (; i < maxComparePosition; i++) {
            int newNum = Integer.parseInt(newVersionSnippet[i]);
            int oldNum = Integer.parseInt(oldVersionSnippet[i]);

            if (newNum == oldNum) {
                continue;
            }

            if (newNum > oldNum) {
                return 1;
            }
            return -1;
        }

        //前面的都相等,比较长度
        if (i == maxComparePosition) {
            return newVersionSnippet.length - oldVersionSnippet.length;
        }

        return 0;
    }
}
