/*
 * Decompiled with CFR 0.152.
 */
package me.codeboy.tools.io;

import java.util.List;
import me.codeboy.tools.io.CBLog;
import me.codeboy.tools.lang.CBString;
import me.codeboy.tools.util.CBDate;

final class CBDummyLogger
implements CBLog.CBLogger {
    private static final String BLACK = "\u001b[0;30m";
    private static final String RED = "\u001b[0;31m";
    private static final String GREEN = "\u001b[0;32m";
    private static final String YELLOW = "\u001b[0;33m";
    private static final String BLUE = "\u001b[0;34m";
    private static final String PURPLE = "\u001b[0;35m";
    private static final String CYAN = "\u001b[0;36m";
    private static final String WHITE = "\u001b[0;37m";
    private static final String RESET = "\u001b[0m";
    private static final String DEBUG = "DEBUG";
    private static final String INFO = "INFO";
    private static final String WARN = "WARN";
    private static final String ERROR = "ERROR";

    CBDummyLogger() {
    }

    @Override
    public void debug(String msg) {
        this.log(msg, DEBUG, CYAN);
    }

    @Override
    public void debug(String format, Object ... param) {
        this.debug(this.format(format, param));
    }

    @Override
    public void debug(String msg, Throwable throwable) {
        this.debug(msg);
        throwable.printStackTrace();
    }

    @Override
    public void info(String msg) {
        this.log(msg, INFO, GREEN);
    }

    @Override
    public void info(String format, Object ... param) {
        this.info(this.format(format, param));
    }

    @Override
    public void info(String msg, Throwable throwable) {
        this.info(msg);
        throwable.printStackTrace();
    }

    @Override
    public void warn(String msg) {
        this.log(msg, WARN, YELLOW);
    }

    @Override
    public void warn(String format, Object ... param) {
        this.warn(this.format(format, param));
    }

    @Override
    public void warn(String msg, Throwable throwable) {
        this.warn(msg);
        throwable.printStackTrace();
    }

    @Override
    public void error(String msg) {
        this.log(msg, ERROR, RED);
    }

    @Override
    public void error(String msg, Object ... param) {
        this.error(this.format(msg, param));
    }

    @Override
    public void error(String msg, Throwable throwable) {
        this.error(msg);
        throwable.printStackTrace();
    }

    private void log(String log, String level, String color) {
        System.out.printf("%s %s%5s%s %s%5d%s --- [%16s] %32s : %s\n", CBDate.formatTimeWithMs(), color, level, RESET, PURPLE, Thread.currentThread().getId(), RESET, Thread.currentThread().getName(), this.getInvokeClass(), log);
    }

    private String format(String format, Object ... arguments) {
        List<String> items = CBString.split(format, "{}");
        if (items.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(items.get(0));
        int paramLen = arguments.length;
        for (int i = 1; i < items.size(); ++i) {
            if (paramLen >= i) {
                sb.append(arguments[i - 1]);
            }
            sb.append(items.get(i));
        }
        return sb.toString();
    }

    private String getInvokeClass() {
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        boolean find = false;
        String logClass = CBLog.class.getName();
        for (StackTraceElement element : stack) {
            int position;
            if (!find && !element.getClassName().equals(logClass)) continue;
            find = true;
            if (element.getClassName().equals(logClass)) continue;
            String invokeClass = element.getClassName();
            if (invokeClass.length() <= 32) {
                return invokeClass;
            }
            String[] items = invokeClass.split("\\.");
            int count = 0;
            int len = items.length;
            for (int i = position = len - 1; i >= 0; --i) {
                int j;
                if ((count += items[i].length()) + (i - 1) * 2 <= 32) continue;
                StringBuilder sb = new StringBuilder();
                for (j = 0; j <= i; ++j) {
                    sb.append(items[j].charAt(0));
                    sb.append(".");
                }
                for (j = i + 1; j < len; ++j) {
                    sb.append(items[j]);
                    if (j == len - 1) continue;
                    sb.append(".");
                }
                return sb.toString();
            }
            break;
        }
        return "";
    }
}

