/*
 * Decompiled with CFR 0.152.
 */
package me.codeboy.tools.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import me.codeboy.tools.util.CBBase64;

public class CBFile {
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;

    public static String getProjectPath() {
        return new File("").getAbsolutePath();
    }

    public static byte[] getContent(String filePath) throws IOException {
        return CBFile.getContent(new File(filePath));
    }

    public static byte[] getContent(File file) throws IOException {
        FileInputStream inputStream = new FileInputStream(file);
        byte[] bytes = new byte[inputStream.available()];
        inputStream.read(bytes);
        inputStream.close();
        return bytes;
    }

    public static byte[] getContent(InputStream is) throws IOException {
        int len;
        byte[] buffer = new byte[4096];
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        while ((len = is.read(buffer)) != -1) {
            outputStream.write(buffer, 0, len);
        }
        outputStream.close();
        is.close();
        return outputStream.toByteArray();
    }

    public static String getContentAsString(String filePath) throws IOException {
        return CBFile.getContentAsString(filePath, DEFAULT_CHARSET);
    }

    public static String getContentAsString(String filePath, Charset charset) throws IOException {
        BufferedReader buff = new BufferedReader(new InputStreamReader(Files.newInputStream(Paths.get(filePath, new String[0]), new OpenOption[0]), charset));
        String content = CBFile.getContentAsString(buff);
        buff.close();
        return content;
    }

    public static String getContentAsString(File file) throws IOException {
        return CBFile.getContentAsString(Files.newInputStream(file.toPath(), new OpenOption[0]));
    }

    public static String getContentAsString(File file, Charset charset) throws IOException {
        BufferedReader buff = new BufferedReader(new InputStreamReader(Files.newInputStream(file.toPath(), new OpenOption[0]), charset));
        String content = CBFile.getContentAsString(buff);
        buff.close();
        return content;
    }

    public static String getContentAsString(InputStream is) throws IOException {
        BufferedReader buff = new BufferedReader(new InputStreamReader(is, DEFAULT_CHARSET));
        String content = CBFile.getContentAsString(buff);
        buff.close();
        return content;
    }

    public static String getContentAsString(InputStream is, Charset charset) throws IOException {
        BufferedReader buff = new BufferedReader(new InputStreamReader(is, charset));
        String content = CBFile.getContentAsString(buff);
        buff.close();
        return content;
    }

    private static String getContentAsString(BufferedReader buff) throws IOException {
        String line;
        StringBuilder content = new StringBuilder();
        while ((line = buff.readLine()) != null) {
            content.append('\n');
            content.append(line);
        }
        if (content.length() > 0) {
            return content.substring(1);
        }
        return "";
    }

    public static String getContentAsBase64(String filePath) throws IOException {
        return CBBase64.encodeToString(CBFile.getContent(filePath));
    }

    public static String getContentAsBase64(File file) throws IOException {
        return CBBase64.encodeToString(CBFile.getContent(file));
    }

    public static List<String> getContentAsList(String filePath) throws IOException {
        return CBFile.getContentAsList(filePath, DEFAULT_CHARSET);
    }

    public static List<String> getContentAsList(String filePath, Charset charset) throws IOException {
        return CBFile.getContentAsList(new File(filePath), charset);
    }

    public static List<String> getContentAsList(File file) throws IOException {
        return CBFile.getContentAsList(file, DEFAULT_CHARSET);
    }

    public static List<String> getContentAsList(File file, Charset charset) throws IOException {
        return Arrays.asList(CBFile.getContentAsString(Files.newInputStream(file.toPath(), new OpenOption[0]), charset).split("\\n"));
    }

    public static <T> T getContentAsObject(String filePath) throws IOException, ClassNotFoundException {
        return CBFile.getContentAsObject(new File(filePath));
    }

    public static <T> T getContentAsObject(File file) throws IOException, ClassNotFoundException {
        ObjectInputStream objectInputStream = new ObjectInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));
        return (T)objectInputStream.readObject();
    }

    public static void saveContent(Object object, String filePath) throws IOException {
        CBFile.saveContent(object, new File(filePath));
    }

    public static void saveContent(Object object, File file) throws IOException {
        if (object == null) {
            return;
        }
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(Files.newOutputStream(file.toPath(), new OpenOption[0]));
        objectOutputStream.writeObject(object);
        objectOutputStream.close();
    }

    public static void saveContent(byte[] bytes, String filePath) throws IOException {
        CBFile.saveContent(bytes, new File(filePath));
    }

    public static void saveContent(byte[] bytes, File file) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        fos.write(bytes);
        fos.flush();
        fos.close();
    }

    public static void saveContent(InputStream is, String filePath) throws IOException {
        CBFile.saveContent(is, new File(filePath));
    }

    public static void saveContent(InputStream is, File file) throws IOException {
        Files.copy(is, file.toPath(), new CopyOption[0]);
    }

    public static void saveContent(String content, String filePath) throws IOException {
        CBFile.saveContent(content, filePath, DEFAULT_CHARSET);
    }

    public static void saveContent(String content, File file) throws IOException {
        CBFile.saveContent(content, file, DEFAULT_CHARSET, false);
    }

    public static void saveContent(String content, String filePath, Charset charset) throws IOException {
        CBFile.saveContent(content, filePath, charset, false);
    }

    public static void saveContent(String content, File file, Charset charset) throws IOException {
        CBFile.saveContent(content, file, charset, false);
    }

    public static void saveContent(String content, String filePath, boolean append) throws IOException {
        CBFile.saveContent(content, new File(filePath), DEFAULT_CHARSET, append);
    }

    public static void saveContent(String content, File file, boolean append) throws IOException {
        CBFile.saveContent(content, file, DEFAULT_CHARSET, append);
    }

    public static void saveContent(String content, String filePath, Charset charset, boolean append) throws IOException {
        CBFile.saveContent(content, new File(filePath), charset, append);
    }

    public static void saveContent(String content, File file, Charset charset, boolean append) throws IOException {
        BufferedWriter buff = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, append), charset));
        buff.write(content);
        buff.flush();
        buff.close();
    }

    public static void download(URL url, String filePath) throws IOException {
        CBFile.download(url, new File(filePath));
    }

    public static void download(URL url, File file) throws IOException {
        InputStream is = url.openStream();
        CBFile.saveContent(is, file);
        is.close();
    }
}

